/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.suggestion.SoundTypeSuggestions;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SoundData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.resources.ResourceLocation;

public class SoundCommand
extends Command {
    private SoundCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"sound").requires(cs -> cs.m_6761_(0))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).suggests(SoundTypeSuggestions::suggest).then(Commands.m_82129_((String)"sound", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SuggestionProviders.f_121643_).executes(context -> SoundCommand.setSoundType((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), SoundType.get(StringArgumentType.getString((CommandContext)context, (String)"type")), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"sound")))))));
    }

    private static int setSoundType(CommandSourceStack context, EasyNPC<?> easyNPC, SoundType soundType, ResourceLocation sound) {
        if (easyNPC == null || soundType == null || sound == null) {
            return 0;
        }
        SoundData<?> soundData = easyNPC.getEasyNPCSoundData();
        if (soundData == null) {
            return SoundCommand.sendFailureMessageNoSoundData(context, easyNPC);
        }
        SoundDataSet soundDataSet = soundData.getSoundDataSet();
        if (soundDataSet == null) {
            return SoundCommand.sendFailureMessageNoSoundDataSet(context, easyNPC);
        }
        soundDataSet.addSound(soundType, sound);
        soundData.refreshSoundDataSet();
        return SoundCommand.sendSuccessMessage(context, "Sound type " + soundType + " for EasyNPC " + easyNPC.m_20148_() + " was set to " + sound + " !");
    }
}

