/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.suggestion.PresetSuggestions;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.PresetHandler;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class PresetCommand
extends Command {
    private static final String COMMAND_NAME = "preset";
    private static final String CUSTOM_ARG = "custom";
    private static final String DATA_ARG = "data";
    private static final String DEFAULT_ARG = "default";
    private static final String EXPORT_ARG = "export";
    private static final String IMPORT_ARG = "import";
    private static final String IMPORT_NEW_ARG = "import_new";
    private static final String IMPORT_WITH_OWNER_ARG = "import_with_owner";
    private static final String LOCAL_ARG = "local";
    private static final String LOCATION_ARG = "location";
    private static final String PRESET_ARG = "preset";
    private static final String NAME_ARG = "name";
    private static final String UUID_ARG = "uuid";
    private static final String WORLD_ARG = "world";

    private PresetCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"preset").requires(cs -> cs.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)EXPORT_ARG).then(Commands.m_82127_((String)LOCAL_ARG).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PresetCommand.exportLocalPreset((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), null))).then(Commands.m_82129_((String)NAME_ARG, (ArgumentType)StringArgumentType.string()).executes(context -> PresetCommand.exportLocalPreset((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)NAME_ARG))))))).then(Commands.m_82127_((String)CUSTOM_ARG).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PresetCommand.exportCustomPreset((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), null))).then(Commands.m_82129_((String)NAME_ARG, (ArgumentType)StringArgumentType.string()).executes(context -> PresetCommand.exportCustomPreset((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)NAME_ARG))))))).then(Commands.m_82127_((String)WORLD_ARG).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PresetCommand.exportWorldPreset((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), null))).then(Commands.m_82129_((String)NAME_ARG, (ArgumentType)StringArgumentType.string()).executes(context -> PresetCommand.exportWorldPreset((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)NAME_ARG)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)IMPORT_ARG).then(Commands.m_82127_((String)LOCAL_ARG).executes(context -> PresetCommand.importLocalPreset((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)CUSTOM_ARG).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestCustom).executes(context -> PresetCommand.importCustomPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), null, null, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importCustomPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), null, null);
        })).then(Commands.m_82129_((String)UUID_ARG, (ArgumentType)UuidArgument.m_113850_()).executes(context -> {
            UUID uuid = UuidArgument.m_113853_((CommandContext)context, (String)UUID_ARG);
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importCustomPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), uuid, null);
        })))))).then(Commands.m_82127_((String)DATA_ARG).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestData).executes(context -> PresetCommand.importDefaultPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), null, null, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDataPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), null, null);
        })).then(Commands.m_82129_((String)UUID_ARG, (ArgumentType)UuidArgument.m_113850_()).executes(context -> {
            UUID uuid = UuidArgument.m_113853_((CommandContext)context, (String)UUID_ARG);
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDataPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), uuid, null);
        })))))).then(Commands.m_82127_((String)DEFAULT_ARG).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestDefault).executes(context -> PresetCommand.importDefaultPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), null, null, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDefaultPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), null, null);
        })).then(Commands.m_82129_((String)UUID_ARG, (ArgumentType)UuidArgument.m_113850_()).executes(context -> {
            UUID uuid = UuidArgument.m_113853_((CommandContext)context, (String)UUID_ARG);
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDefaultPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), uuid, null);
        })))))).then(Commands.m_82127_((String)WORLD_ARG).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestWorld).executes(context -> PresetCommand.importWorldPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), null, null, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importWorldPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), null, null);
        })).then(Commands.m_82129_((String)UUID_ARG, (ArgumentType)UuidArgument.m_113850_()).executes(context -> {
            UUID uuid = UuidArgument.m_113853_((CommandContext)context, (String)UUID_ARG);
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importWorldPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), uuid, null);
        }))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)IMPORT_NEW_ARG).then(Commands.m_82127_((String)CUSTOM_ARG).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestCustom).executes(context -> PresetCommand.importCustomPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), null, UUID.randomUUID(), null))).then(Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importCustomPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), UUID.randomUUID(), null);
        }))))).then(Commands.m_82127_((String)DATA_ARG).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestData).executes(context -> PresetCommand.importDefaultPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), null, UUID.randomUUID(), null))).then(Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDataPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), UUID.randomUUID(), null);
        }))))).then(Commands.m_82127_((String)DEFAULT_ARG).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestDefault).executes(context -> PresetCommand.importDefaultPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), null, UUID.randomUUID(), null))).then(Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDefaultPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), UUID.randomUUID(), null);
        }))))).then(Commands.m_82127_((String)WORLD_ARG).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestWorld).executes(context -> PresetCommand.importWorldPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), null, UUID.randomUUID(), null))).then(Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importWorldPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), UUID.randomUUID(), null);
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)IMPORT_WITH_OWNER_ARG).then(Commands.m_82127_((String)CUSTOM_ARG).then(Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestCustom).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importCustomPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), UUID.randomUUID(), EntityArgument.m_91474_((CommandContext)context, (String)"player"));
        })))))).then(Commands.m_82127_((String)DATA_ARG).then(Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestData).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDataPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), UUID.randomUUID(), EntityArgument.m_91474_((CommandContext)context, (String)"player"));
        })))))).then(Commands.m_82127_((String)DEFAULT_ARG).then(Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestDefault).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importDefaultPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), UUID.randomUUID(), EntityArgument.m_91474_((CommandContext)context, (String)"player"));
        })))))).then(Commands.m_82127_((String)WORLD_ARG).then(Commands.m_82129_((String)"preset", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PresetSuggestions::suggestWorld).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)LOCATION_ARG, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)LOCATION_ARG);
            return PresetCommand.importWorldPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"preset"), coordinates.m_6955_((CommandSourceStack)context.getSource()), UUID.randomUUID(), EntityArgument.m_91474_((CommandContext)context, (String)"player"));
        }))))));
    }

    private static int importCustomPreset(CommandSourceStack context, ResourceLocation preset, Vec3 position, UUID uuid, ServerPlayer serverPlayer) {
        if (preset == null) {
            return 0;
        }
        if (!PresetHandler.importCustomPreset(context.m_81372_(), preset, position, uuid, serverPlayer)) {
            return PresetCommand.sendFailureMessage(context, PresetCommand.importedPresetFailedMessage(CUSTOM_ARG, preset));
        }
        return PresetCommand.sendSuccessMessage(context, PresetCommand.importedPresetMessage(CUSTOM_ARG, preset, position, uuid));
    }

    private static int importDataPreset(CommandSourceStack context, ResourceLocation preset, Vec3 position, UUID uuid, ServerPlayer serverPlayer) {
        if (preset == null) {
            return 0;
        }
        if (!PresetHandler.importDataPreset(context.m_81372_(), preset, position, uuid, serverPlayer)) {
            return PresetCommand.sendFailureMessage(context, PresetCommand.importedPresetFailedMessage(DATA_ARG, preset));
        }
        return PresetCommand.sendSuccessMessage(context, PresetCommand.importedPresetMessage(DATA_ARG, preset, position, uuid));
    }

    private static int importDefaultPreset(CommandSourceStack context, ResourceLocation preset, Vec3 position, UUID uuid, ServerPlayer serverPlayer) {
        if (preset == null) {
            return 0;
        }
        if (!PresetHandler.importDefaultPreset(context.m_81372_(), preset, position, uuid, serverPlayer)) {
            return PresetCommand.sendFailureMessage(context, PresetCommand.importedPresetFailedMessage(DEFAULT_ARG, preset));
        }
        return PresetCommand.sendSuccessMessage(context, PresetCommand.importedPresetMessage(DEFAULT_ARG, preset, position, uuid));
    }

    private static int importLocalPreset(CommandSourceStack context) {
        return PresetCommand.sendFailureMessage(context, "Importing a local preset from the server is not supported!");
    }

    private static int importWorldPreset(CommandSourceStack context, ResourceLocation preset, Vec3 position, UUID uuid, ServerPlayer serverPlayer) {
        if (preset == null) {
            return 0;
        }
        if (!PresetHandler.importWorldPreset(context.m_81372_(), preset, position, uuid, serverPlayer)) {
            return PresetCommand.sendFailureMessage(context, PresetCommand.importedPresetFailedMessage(WORLD_ARG, preset));
        }
        return PresetCommand.sendSuccessMessage(context, PresetCommand.importedPresetMessage(WORLD_ARG, preset, position, uuid));
    }

    private static String importedPresetFailedMessage(String presetType, ResourceLocation preset) {
        return "Unable to import " + presetType + " preset " + preset + " !";
    }

    private static String importedPresetMessage(String presetType, ResourceLocation preset, Vec3 position, UUID uuid) {
        return "Imported " + presetType + " preset " + preset + (String)(position != null ? " at " + position : "") + (String)(uuid != null ? " with UUID " + uuid : "") + " !";
    }

    private static int exportCustomPreset(CommandSourceStack context, EasyNPC<?> easyNPC, String name) {
        if (easyNPC == null) {
            return 0;
        }
        if (!PresetHandler.exportCustomPreset(easyNPC, name)) {
            return PresetCommand.sendFailureMessage(context, "Unable to export custom preset for " + easyNPC + "!");
        }
        return PresetCommand.sendSuccessMessage(context, "Exporting custom preset " + name + " for " + easyNPC + " with UUID " + easyNPC.m_20148_() + "!");
    }

    private static int exportWorldPreset(CommandSourceStack context, EasyNPC<?> easyNPC, String name) {
        if (easyNPC == null) {
            return 0;
        }
        if (!PresetHandler.exportWorldPreset(easyNPC, name)) {
            return PresetCommand.sendFailureMessage(context, "Unable to export world preset for " + easyNPC + "!");
        }
        return PresetCommand.sendSuccessMessage(context, "Exporting world preset " + name + " for " + easyNPC + " with UUID " + easyNPC.m_20148_() + "!");
    }

    private static int exportLocalPreset(CommandSourceStack context, EasyNPC<?> easyNPC, String name) {
        ServerPlayer serverPlayer;
        if (easyNPC == null) {
            return 0;
        }
        try {
            serverPlayer = context.m_81375_();
        }
        catch (CommandSyntaxException e) {
            return PresetCommand.sendFailureMessage(context, "This command can only be executed by a player!");
        }
        String presetFileName = CustomPresetDataFiles.getPresetFileName(name != null && !name.isEmpty() ? name : easyNPC.m_20148_().toString());
        NetworkMessageHandlerManager.getClientHandler().exportClientPreset(easyNPC.m_20148_(), presetFileName, serverPlayer);
        return PresetCommand.sendSuccessMessage(context, "Exporting EasyNPC " + easyNPC.getEntity().m_5446_().getString() + " locally to config/easy_npc/preset/" + easyNPC.getEasyNPCSkinData().getSkinModel().getName() + "/" + presetFileName + " !");
    }
}

