/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelScaleAxis;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeScaleMessage(UUID uuid, ModelScaleAxis scaleAxis, Float scaleValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "change_scale");

    public static ChangeScaleMessage create(FriendlyByteBuf buffer) {
        return new ChangeScaleMessage(buffer.m_130259_(), (ModelScaleAxis)buffer.m_130066_(ModelScaleAxis.class), Float.valueOf(buffer.readFloat()));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.scaleAxis);
        buffer.writeFloat(this.scaleValue.floatValue());
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.scaleAxis == null) {
            log.error("Invalid scale axis request for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.scaleValue == null || this.scaleValue.floatValue() < 0.1f || this.scaleValue.floatValue() > 10.0f) {
            log.error("Invalid scale {} request for UUID {} from {}", (Object)this.scaleValue, easyNPC, (Object)serverPlayer);
            return;
        }
        ScaleData<?> scaleData = easyNPC.getEasyNPCScaleData();
        if (scaleData == null) {
            log.error("Invalid scale data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        scaleData.setModelScaleAxis(this.scaleAxis, this.scaleValue);
    }
}

