/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.ResetUniversalAngerTargetGoal;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerData;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;

public interface ObjectiveData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final ServerDataAccessor<ObjectiveDataSet> CUSTOM_DATA_OBJECTIVE_DATA_SET = ServerEntityData.defineId(ServerDataIndex.OBJECTIVE_DATA_SET, EntityDataSerializersManager.OBJECTIVE_DATA_SET);
    public static final ServerDataAccessor<HashSet<UUID>> CUSTOM_DATA_TARGETED_ENTITY_SET = ServerEntityData.defineId(ServerDataIndex.OBJECTIVE_ENTITY_SET, EntityDataSerializersManager.TARGETED_ENTITY_HASH_SET);
    public static final ServerDataAccessor<HashSet<String>> CUSTOM_DATA_TARGETED_PLAYER_SET = ServerEntityData.defineId(ServerDataIndex.OBJECTIVE_PLAYER_SET, EntityDataSerializersManager.TARGETED_PLAYER_HASH_SET);
    public static final int CUSTOM_OBJECTIVE_DELAYED_REGISTRATION_TICK = 300;
    public static final String DATA_HAS_ENTITY_TARGET_TAG = "HasEntityTarget";
    public static final String DATA_HAS_OBJECTIVE_TAG = "HasObjectives";
    public static final String DATA_HAS_PLAYER_TARGET_TAG = "HasPlayerTarget";
    public static final String DATA_HAS_TRAVEL_TARGET_TAG = "HasTravelTarget";
    public static final String DATA_OBJECTIVE_DATA_TAG = "ObjectiveData";

    default public ObjectiveDataSet getObjectiveDataSet() {
        return this.getEasyNPCServerData().getServerEntityData(CUSTOM_DATA_OBJECTIVE_DATA_SET);
    }

    default public void setObjectiveDataSet(ObjectiveDataSet objectiveDataSet) {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_OBJECTIVE_DATA_SET, objectiveDataSet);
    }

    default public boolean hasObjective(String objectiveId) {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasObjective(objectiveId);
    }

    default public boolean hasObjective(ObjectiveType objectiveType) {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasObjective(objectiveType);
    }

    default public boolean hasObjective(ObjectiveDataEntry objectiveDataEntry) {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasObjective(objectiveDataEntry.getId());
    }

    default public boolean hasObjectives() {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasObjectives();
    }

    default public boolean hasObjectives(Set<ObjectiveType> objectiveTypes) {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasObjectives(objectiveTypes);
    }

    default public ObjectiveDataEntry getObjective(ObjectiveType objectiveType) {
        return this.getObjectiveDataSet() != null && objectiveType != null ? this.getObjectiveDataSet().getObjective(objectiveType) : null;
    }

    default public Optional<ObjectiveDataEntry> getObjectiveEntry(ObjectiveType objectiveType) {
        return this.getObjectiveDataSet() != null ? Optional.ofNullable(this.getObjectiveDataSet().getObjective(objectiveType)) : Optional.empty();
    }

    default public boolean removeObjective(ObjectiveType objectiveType) {
        if (objectiveType == null) {
            return false;
        }
        return this.getObjectiveDataSet().removeObjective(objectiveType);
    }

    default public void addObjective(ObjectiveDataEntry objectiveDataEntry) {
        if (objectiveDataEntry == null) {
            return;
        }
        this.getObjectiveDataSet().addObjective(objectiveDataEntry);
    }

    default public boolean hasTravelTargetObjectives() {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasTravelTarget();
    }

    default public boolean hasPlayerTargetObjectives() {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasPlayerTarget();
    }

    default public boolean hasEntityTargetObjectives() {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasEntityTarget();
    }

    default public boolean hasOwnerTargetObjectives() {
        return this.getObjectiveDataSet() != null && this.getObjectiveDataSet().hasOwnerTarget();
    }

    default public void onEasyNPCJoinUpdateObjective(EasyNPC<?> easyNPC) {
        if (this.hasEntityTargetObjectives() && !this.getObjectiveDataSet().hasValidTarget(this) && this.getObjectiveDataSet().isTargetedEntity(easyNPC.m_20148_())) {
            this.refreshCustomObjectives();
        }
    }

    default public void onEasyNPCLeaveUpdateObjective(EasyNPC<?> easyNPC) {
        if (this.hasEntityTargetObjectives() && this.getObjectiveDataSet().hasValidTarget(this) && this.getObjectiveDataSet().isTargetedEntity(this.m_20148_())) {
            this.refreshCustomObjectives();
        }
    }

    default public void onPlayerJoinUpdateObjective(ServerPlayer serverPlayer) {
        if (this.hasOwnerTargetObjectives() && !this.getObjectiveDataSet().hasValidTarget(this) && (this.isObjectiveOwner(serverPlayer) || this.isObjectiveTargetedPlayer(serverPlayer))) {
            this.refreshCustomObjectives();
        }
    }

    private boolean isObjectiveOwner(ServerPlayer serverPlayer) {
        return this.getEasyNPCOwnerData() != null && this.getEasyNPCOwnerData().isOwner(serverPlayer);
    }

    private boolean isObjectiveTargetedPlayer(ServerPlayer serverPlayer) {
        return this.getObjectiveDataSet().isTargetedPlayer(serverPlayer.m_7755_().getString());
    }

    default public void onPlayerLeaveUpdateObjective(ServerPlayer serverPlayer) {
        if (this.hasOwnerTargetObjectives() && this.getObjectiveDataSet().hasValidTarget(this) && (this.isObjectiveOwner(serverPlayer) || this.isObjectiveTargetedPlayer(serverPlayer))) {
            this.refreshCustomObjectives();
        }
    }

    default public void onLivingEntityJoinUpdateObjective(LivingEntity livingEntity) {
        if (this.hasEntityTargetObjectives() && !this.getObjectiveDataSet().hasValidTarget(this) && this.getObjectiveDataSet().isTargetedEntity(livingEntity.m_20148_())) {
            this.refreshCustomObjectives();
        }
    }

    default public void onLivingEntityLeaveUpdateObjective(LivingEntity livingEntity) {
        if (this.hasObjectives() && this.getObjectiveDataSet().hasValidTarget(this) && this.getObjectiveDataSet().isTargetedEntity(livingEntity.m_20148_())) {
            this.refreshCustomObjectives();
        }
    }

    default public void refreshCustomObjectives() {
        if (this.m_183595_()) {
            return;
        }
        for (ObjectiveDataEntry objectiveDataEntry : this.getObjectiveDataSet().getObjectives()) {
            if (objectiveDataEntry == null || objectiveDataEntry.getType() == ObjectiveType.NONE || objectiveDataEntry.hasValidTarget(this) && objectiveDataEntry.isRegistered()) continue;
            log.debug("Refresh Objective {} for {}", (Object)objectiveDataEntry, (Object)this);
            this.addOrUpdateCustomObjective(objectiveDataEntry);
        }
    }

    default public void registerAttributeBasedObjectives() {
        if (this.m_183595_()) {
            return;
        }
        log.debug("Register attribute based objectives for {}", (Object)this);
        ObjectiveDataEntry floatObjective = new ObjectiveDataEntry(ObjectiveType.FLOAT, 0);
        EntityAttributes attributeData = this.getEasyNPCAttributeData().getEntityAttributes();
        if (attributeData.getEnvironmentalAttributes().canFloat()) {
            if (!this.hasObjective(floatObjective)) {
                this.addOrUpdateCustomObjective(floatObjective);
            }
        } else if (this.hasObjective(floatObjective)) {
            this.removeCustomObjective(floatObjective);
        }
        ObjectiveDataEntry closeDoorObjective = new ObjectiveDataEntry(ObjectiveType.CLOSE_DOOR, 8);
        if (attributeData.getMovementAttributes().canCloseDoor()) {
            if (!this.hasObjective(closeDoorObjective)) {
                this.addOrUpdateCustomObjective(closeDoorObjective);
            }
        } else if (this.hasObjective(closeDoorObjective)) {
            this.removeCustomObjective(closeDoorObjective);
        }
        ObjectiveDataEntry openDoorObjective = new ObjectiveDataEntry(ObjectiveType.OPEN_DOOR, 8);
        if (attributeData.getMovementAttributes().canOpenDoor()) {
            if (!this.hasObjective(closeDoorObjective)) {
                this.addOrUpdateCustomObjective(openDoorObjective);
            }
        } else if (this.hasObjective(openDoorObjective)) {
            this.removeCustomObjective(openDoorObjective);
        }
    }

    default public void registerCustomObjectives() {
        if (this.m_183595_()) {
            return;
        }
        Set<ObjectiveDataEntry> objectives = this.getObjectiveDataSet().getObjectives();
        if (objectives == null || objectives.isEmpty()) {
            return;
        }
        log.debug("Register custom objectives for {}", (Object)this);
        GoalSelector targetSelector = this.getEntityTargetSelector();
        for (ObjectiveDataEntry objectiveDataEntry : objectives) {
            this.addOrUpdateCustomObjective(objectiveDataEntry);
        }
        if (!targetSelector.m_148105_().isEmpty()) {
            log.debug("- Register reset universal anger target for {}", (Object)this);
            targetSelector.m_25352_(4, new ResetUniversalAngerTargetGoal<ObjectiveData>(this, false));
        }
    }

    default public boolean addOrUpdateCustomObjective(ObjectiveDataEntry objectiveDataEntry) {
        Goal target;
        if (objectiveDataEntry == null || objectiveDataEntry.getType() == ObjectiveType.NONE) {
            log.error("- Unable to add custom objective {} for {}!", (Object)objectiveDataEntry, (Object)this);
            return false;
        }
        boolean addedCustomObjective = false;
        Goal goal = objectiveDataEntry.getGoal(this);
        if (goal != null) {
            GoalSelector goalSelector = this.getEntityGoalSelector();
            if (!objectiveDataEntry.hasValidTarget(this)) {
                if (this.hasObjective(objectiveDataEntry.getId()) && objectiveDataEntry.isRegistered()) {
                    log.warn("- Removing existing goal {} for {} because target was not found! Will try later again.", (Object)goal, (Object)this);
                }
                goalSelector.m_25363_(goal);
            } else {
                log.debug("- Adding goal {} for {}", (Object)goal, (Object)this);
                goalSelector.m_25363_(goal);
                goalSelector.m_25352_(objectiveDataEntry.getPriority(), goal);
                addedCustomObjective = true;
            }
        }
        if ((target = objectiveDataEntry.getTarget(this)) != null) {
            log.debug("- Adding target goal {} for {}", (Object)target, (Object)this);
            GoalSelector targetSelector = this.getEntityTargetSelector();
            targetSelector.m_25363_(target);
            targetSelector.m_25352_(objectiveDataEntry.getPriority(), target);
            addedCustomObjective = true;
        }
        objectiveDataEntry.setRegistered(addedCustomObjective);
        this.getObjectiveDataSet().addObjective(objectiveDataEntry);
        return objectiveDataEntry.isRegistered();
    }

    default public void handleCustomObjectiveBaseTick() {
        TickerData tickerData = this.getEasyNPCTickerData();
        if (tickerData.checkAndIncreaseTicker(TickerType.CUSTOM_OBJECTIVE_DELAYED_REGISTRATION, 300)) {
            if (this.hasObjectives()) {
                this.refreshCustomObjectives();
            }
            tickerData.resetTicker(TickerType.CUSTOM_OBJECTIVE_DELAYED_REGISTRATION);
        }
    }

    default public boolean removeCustomObjective(ObjectiveType objectiveType) {
        return this.removeCustomObjective(this.getObjective(objectiveType));
    }

    default public boolean removeCustomObjective(ObjectiveDataEntry objectiveDataEntry) {
        if (objectiveDataEntry == null || objectiveDataEntry.getType() == ObjectiveType.NONE) {
            log.error("- Unable to remove custom objective {} for {}!", (Object)objectiveDataEntry, (Object)this);
            return false;
        }
        if (objectiveDataEntry.getId() != null && !objectiveDataEntry.getId().isEmpty() && (objectiveDataEntry = this.getObjectiveDataSet().getObjective(objectiveDataEntry.getId())) == null) {
            log.error("- Unable to remove non-existing custom objective {} for {}!", (Object)objectiveDataEntry, (Object)this);
            return false;
        }
        Goal goal = objectiveDataEntry.getGoal(this);
        Goal target = objectiveDataEntry.getTarget(this);
        if (goal == null && target == null) {
            log.error("- Unable to remove custom objective for {}!", (Object)this);
            return false;
        }
        if (goal != null) {
            log.debug("- Removing goal {} for {}", (Object)goal, (Object)this);
            this.getEntityGoalSelector().m_25363_(goal);
        }
        if (target != null) {
            log.debug("- Removing target goal {} for {}", (Object)target, (Object)this);
            this.getEntityTargetSelector().m_25363_(target);
        }
        return this.getObjectiveDataSet().removeObjective(objectiveDataEntry);
    }

    default public void registerStandardObjectives() {
        log.debug("Register standard objectives for {}", (Object)this);
        this.addOrUpdateCustomObjective(new ObjectiveDataEntry(ObjectiveType.LOOK_AT_RESET, 9));
        this.addOrUpdateCustomObjective(new ObjectiveDataEntry(ObjectiveType.LOOK_AT_PLAYER, 9));
        this.addOrUpdateCustomObjective(new ObjectiveDataEntry(ObjectiveType.LOOK_AT_MOB, 10));
    }

    default public void defineCustomObjectiveData() {
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_OBJECTIVE_DATA_SET, new ObjectiveDataSet());
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_TARGETED_PLAYER_SET, new HashSet());
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_TARGETED_ENTITY_SET, new HashSet());
    }

    default public void addAdditionalObjectiveData(CompoundTag compoundTag) {
        CompoundTag objectiveTag = new CompoundTag();
        if (this.isServerSide()) {
            ObjectiveDataSet objectiveDataSet = this.getObjectiveDataSet();
            if (objectiveDataSet != null) {
                objectiveDataSet.save(objectiveTag);
            }
            objectiveTag.m_128379_(DATA_HAS_OBJECTIVE_TAG, this.hasObjectives());
            if (this.hasTravelTargetObjectives()) {
                objectiveTag.m_128379_(DATA_HAS_TRAVEL_TARGET_TAG, this.hasTravelTargetObjectives());
            }
            if (this.hasPlayerTargetObjectives()) {
                objectiveTag.m_128379_(DATA_HAS_PLAYER_TARGET_TAG, this.hasPlayerTargetObjectives());
            }
            if (this.hasEntityTargetObjectives()) {
                objectiveTag.m_128379_(DATA_HAS_ENTITY_TARGET_TAG, this.hasEntityTargetObjectives());
            }
        }
        compoundTag.m_128365_(DATA_OBJECTIVE_DATA_TAG, (Tag)objectiveTag);
    }

    default public void readAdditionalObjectiveData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(DATA_OBJECTIVE_DATA_TAG)) {
            return;
        }
        CompoundTag objectiveDataTag = compoundTag.m_128469_(DATA_OBJECTIVE_DATA_TAG);
        if (objectiveDataTag.m_128441_("ObjectiveDataSet")) {
            ObjectiveDataSet objectiveDataSet = new ObjectiveDataSet(objectiveDataTag);
            this.setObjectiveDataSet(objectiveDataSet);
            this.registerCustomObjectives();
        }
        if (this.getNPCDataVersion() == -1) {
            this.registerStandardObjectives();
        }
    }
}

