/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import de.markusbordihn.easynpc.data.action.ActionGroup;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Mob;

public class ActionManager {
    private static final HashMap<Mob, EnumMap<ActionGroup, HashSet<ServerPlayer>>> actionGroupPlayerMap = new HashMap();

    private ActionManager() {
    }

    public static void addPlayer(Mob mob, ActionGroup actionGroup, ServerPlayer serverPlayer) {
        HashSet<Object> playerList;
        if (mob == null || actionGroup == null || serverPlayer == null) {
            return;
        }
        EnumMap<ActionGroup, HashSet<Object>> actionGroupPlayer = actionGroupPlayerMap.get(mob);
        if (actionGroupPlayer == null) {
            actionGroupPlayer = new EnumMap(ActionGroup.class);
        }
        if ((playerList = actionGroupPlayer.get((Object)actionGroup)) == null) {
            playerList = new HashSet();
        }
        playerList.add(serverPlayer);
        actionGroupPlayer.put(actionGroup, playerList);
        actionGroupPlayerMap.put(mob, actionGroupPlayer);
    }

    public static boolean containsPlayer(Mob mob, ActionGroup actionGroup, ServerPlayer serverPlayer) {
        if (mob == null || actionGroup == null || serverPlayer == null) {
            return false;
        }
        EnumMap<ActionGroup, HashSet<ServerPlayer>> actionGroupPlayer = actionGroupPlayerMap.get(mob);
        if (actionGroupPlayer == null) {
            return false;
        }
        HashSet<ServerPlayer> playerList = actionGroupPlayer.get((Object)actionGroup);
        if (playerList == null) {
            return false;
        }
        return playerList.contains(serverPlayer);
    }

    public static void removePlayer(Mob mob, ActionGroup actionGroup, ServerPlayer serverPlayer) {
        if (mob == null || actionGroup == null || serverPlayer == null) {
            return;
        }
        EnumMap<ActionGroup, HashSet<ServerPlayer>> actionGroupPlayer = actionGroupPlayerMap.get(mob);
        if (actionGroupPlayer == null) {
            return;
        }
        HashSet<ServerPlayer> playerList = actionGroupPlayer.get((Object)actionGroup);
        if (playerList == null || !playerList.contains(serverPlayer)) {
            return;
        }
        playerList.remove(serverPlayer);
        actionGroupPlayer.put(actionGroup, playerList);
        actionGroupPlayerMap.put(mob, actionGroupPlayer);
    }

    public static void removeActionGroup(Mob mob, ActionGroup actionGroup) {
        if (mob == null || actionGroup == null) {
            return;
        }
        EnumMap<ActionGroup, HashSet<ServerPlayer>> actionGroupPlayer = actionGroupPlayerMap.get(mob);
        if (actionGroupPlayer == null || !actionGroupPlayer.containsKey((Object)actionGroup)) {
            return;
        }
        actionGroupPlayer.remove((Object)actionGroup);
        actionGroupPlayerMap.put(mob, actionGroupPlayer);
    }
}

