/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.commands.selector.EasyNPCSelectorParser;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.UUIDUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCArgument
implements ArgumentType<EntitySelector> {
    public static final SimpleCommandExceptionType NO_ENTITIES_FOUND = new SimpleCommandExceptionType((Message)TextComponent.getTranslatedTextRaw("argument.entity.notfound.entity"));
    private static final Collection<String> EXAMPLES = Arrays.asList("EasyNPC", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public static EasyNPCArgument npc() {
        return new EasyNPCArgument();
    }

    public static EasyNPC<?> getEntityWithAccess(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        EasyNPC easyNPC = EasyNPCArgument.getEntitiesWithAccess(context, name).stream().findFirst().orElse(null);
        if (easyNPC == null) {
            throw NO_ENTITIES_FOUND.create();
        }
        return easyNPC;
    }

    public static Collection<? extends EasyNPC<?>> getEntitiesWithAccess(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        Collection<EasyNPC<?>> easyNPCs = EasyNPCArgument.getEntities(context, name);
        if ((easyNPCs = easyNPCs.stream().filter(easyNPC -> AccessManager.hasAccess((CommandSourceStack)context.getSource(), easyNPC.m_20148_())).toList()).isEmpty()) {
            throw NO_ENTITIES_FOUND.create();
        }
        return easyNPCs;
    }

    public static EasyNPC<?> getEntity(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        EasyNPC easyNPC = EasyNPCArgument.getEntities(context, name).stream().findFirst().orElse(null);
        if (easyNPC == null) {
            throw NO_ENTITIES_FOUND.create();
        }
        return easyNPC;
    }

    public static Collection<? extends EasyNPC<?>> getEntities(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        Collection<EasyNPC<?>> entities = EasyNPCArgument.getOptionalEntities(context, name);
        if (entities.isEmpty()) {
            throw NO_ENTITIES_FOUND.create();
        }
        return entities;
    }

    public static Collection<? extends EasyNPC<?>> getOptionalEntities(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        List entities = ((EntitySelector)context.getArgument(name, EntitySelector.class)).m_121160_((CommandSourceStack)context.getSource());
        ArrayList<EasyNPC> easyNPCs = new ArrayList<EasyNPC>();
        for (Entity entity : entities) {
            if (!(entity instanceof EasyNPC)) continue;
            EasyNPC easyNPC = (EasyNPC)entity;
            easyNPCs.add(easyNPC);
        }
        return easyNPCs;
    }

    public EntitySelector parse(StringReader stringReader) throws CommandSyntaxException {
        UUID uuid;
        EasyNPCSelectorParser entitySelectorParser = new EasyNPCSelectorParser(stringReader);
        String input = stringReader.getRemaining();
        if (input != null && !input.startsWith("@") && input.length() == 36 && (uuid = UUIDUtils.parseUUID(input)) != null && NetworkMessageHandlerManager.getServerHandler() != null) {
            log.debug("Found valid UUID {} and will request data sync...", (Object)uuid);
            NetworkMessageHandlerManager.getServerHandler().requestDataSync(uuid);
        }
        return entitySelectorParser.m_121377_();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestionsBuilder) {
        Object object = context.getSource();
        if (!(object instanceof SharedSuggestionProvider)) {
            return Suggestions.empty();
        }
        SharedSuggestionProvider sharedSuggestionProvider = (SharedSuggestionProvider)object;
        StringReader stringReader = new StringReader(suggestionsBuilder.getInput());
        stringReader.setCursor(suggestionsBuilder.getStart());
        EasyNPCSelectorParser easyNPCSelectorParser = new EasyNPCSelectorParser(stringReader, sharedSuggestionProvider.m_6761_(2));
        try {
            easyNPCSelectorParser.m_121377_();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return easyNPCSelectorParser.m_121249_(suggestionsBuilder, consumer -> {
            Collection result = sharedSuggestionProvider.m_6264_();
            SharedSuggestionProvider.m_82970_((Iterable)result, (SuggestionsBuilder)consumer);
        });
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

