/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.rotation;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.rotation.RotationConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class DefaultRotationConfigurationScreen<T extends ConfigurationMenu>
extends RotationConfigurationScreen<T> {
    protected Button rootRotationXResetButton;
    protected Button rootRotationYResetButton;
    protected Button rootRotationZResetButton;
    protected SliderButton rootRotationXSliderButton;
    protected SliderButton rootRotationYSliderButton;
    protected SliderButton rootRotationZSliderButton;
    protected Checkbox rootRotationCheckbox;
    protected float rootRotationX = 0.0f;
    protected float rootRotationY = 0.0f;
    protected float rootRotationZ = 0.0f;

    public DefaultRotationConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.showCloseButton = true;
        this.renderBackground = false;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.defaultRotationButton.f_93623_ = false;
        ModelData<?> modelData = this.getEasyNPC().getEasyNPCModelData();
        CustomRotation rootRotation = modelData.getModelRootRotation();
        this.rootRotationX = rootRotation.x();
        this.rootRotationY = rootRotation.y();
        this.rootRotationZ = rootRotation.z();
        this.rootRotationXSliderButton = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(this.contentLeftPos, this.contentTopPos, 60, "rootRotationX", (float)Math.toDegrees(rootRotation.x()), SliderButton.Type.DEGREE, slider -> {
            this.rootRotationX = (float)Math.toRadians(slider.getTargetValue());
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), ModelPart.ROOT, new CustomRotation(this.rootRotationX, this.rootRotationY, this.rootRotationZ));
        }));
        this.rootRotationXResetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.rootRotationXSliderButton.m_252754_() + this.rootRotationXSliderButton.m_5711_(), this.contentTopPos, 10, (Component)TextComponent.getText("\u21ba"), button -> {
            this.rootRotationX = 0.0f;
            this.rootRotationXSliderButton.reset();
        }));
        this.rootRotationYSliderButton = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(this.rootRotationXResetButton.m_252754_() + this.rootRotationXResetButton.m_5711_() + 5, this.contentTopPos, 60, "rootRotationY", (float)Math.toDegrees(rootRotation.y()), SliderButton.Type.DEGREE, slider -> {
            this.rootRotationY = (float)Math.toRadians(slider.getTargetValue());
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), ModelPart.ROOT, new CustomRotation(this.rootRotationX, this.rootRotationY, this.rootRotationZ));
        }));
        this.rootRotationYResetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.rootRotationYSliderButton.m_252754_() + this.rootRotationYSliderButton.m_5711_(), this.contentTopPos, 10, (Component)TextComponent.getText("\u21ba"), button -> {
            this.rootRotationY = 0.0f;
            this.rootRotationYSliderButton.reset();
        }));
        this.rootRotationZSliderButton = (SliderButton)this.m_142416_((GuiEventListener)new SliderButton(this.rootRotationYResetButton.m_252754_() + this.rootRotationYResetButton.m_5711_() + 5, this.contentTopPos, 60, "rootRotationZ", (float)Math.toDegrees(rootRotation.z()), SliderButton.Type.DEGREE, slider -> {
            this.rootRotationZ = (float)Math.toRadians(slider.getTargetValue());
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), ModelPart.ROOT, new CustomRotation(this.rootRotationX, this.rootRotationY, this.rootRotationZ));
        }));
        this.rootRotationZResetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.rootRotationZSliderButton.m_252754_() + this.rootRotationZSliderButton.m_5711_(), this.contentTopPos, 10, (Component)TextComponent.getText("\u21ba"), button -> {
            this.rootRotationZ = 0.0f;
            this.rootRotationZSliderButton.reset();
        }));
        this.rootRotationCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.rootRotationZResetButton.m_252754_() + this.rootRotationZResetButton.m_5711_() + 5, this.contentTopPos + 2, "lock_rotation", modelData.getModelLockRotation(), checkbox -> NetworkMessageHandlerManager.getServerHandler().modelLockRotationChange(this.getEasyNPCUUID(), checkbox.selected())));
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        if (this.rootRotationXSliderButton != null) {
            Text.drawString(guiGraphics, this.f_96547_, "Rotation X", this.rootRotationXSliderButton.m_252754_() + 5, this.rootRotationXSliderButton.m_252907_() + 25);
        }
        if (this.rootRotationYSliderButton != null) {
            Text.drawString(guiGraphics, this.f_96547_, "Rotation Y", this.rootRotationYSliderButton.m_252754_() + 5, this.rootRotationYSliderButton.m_252907_() + 25);
        }
        if (this.rootRotationZSliderButton != null) {
            Text.drawString(guiGraphics, this.f_96547_, "Rotation Z", this.rootRotationZSliderButton.m_252754_() + 5, this.rootRotationZSliderButton.m_252907_() + 25);
        }
    }
}

