/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.preset;

import de.markusbordihn.easynpc.client.screen.configuration.preset.ImportPresetConfigurationScreen;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ImportLocalPresetConfigurationScreen<T extends ConfigurationMenu>
extends ImportPresetConfigurationScreen<T> {
    private final List<ResourceLocation> localPresets;

    public ImportLocalPresetConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.importPresetButtonLabel = "import_local_preset";
        this.importPresetHeaderLabel = "preset_local_for";
        this.localPresets = CustomPresetDataFiles.getPresetResourceLocations(this.getSkinModel()).toList();
    }

    @Override
    public void loadPreset(ResourceLocation resourceLocation) {
        try {
            Path presetFilePath = CustomPresetDataFiles.getPresetsResourceLocationPath(resourceLocation);
            NetworkMessageHandlerManager.getServerHandler().importLocalPreset(this.getEasyNPCUUID(), NbtIo.m_128937_((File)presetFilePath.toFile()), resourceLocation);
        }
        catch (Exception e) {
            log.error("Failed to import local preset file {}:", (Object)resourceLocation, (Object)e);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.localImportPresetButton.f_93623_ = false;
        ImportLocalPresetConfigurationScreen.updatePresets(this.localPresets);
        this.presetSelectionList.updatePresets();
    }
}

