/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.dialog;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.dialog.DialogConfigurationScreen;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class NoneDialogConfigurationScreen<T extends ConfigurationMenu>
extends DialogConfigurationScreen<T> {
    protected Checkbox noneDialogCheckbox;
    protected int numberOfTextLines = 1;
    private List<FormattedCharSequence> textComponents = Collections.emptyList();

    public NoneDialogConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.noneDialogButton.f_93623_ = false;
        this.textComponents = this.f_96547_.m_92923_((FormattedText)TextComponent.getTranslatedConfigText("disable_dialog_text"), this.imageWidth - 20);
        this.numberOfTextLines = this.textComponents.size();
        DialogDataSet formerDialogDataSet = this.getDialogDataSet();
        this.noneDialogCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 100, this.topPos + 170, "disable_dialog_checkbox", !this.hasDialog(), checkbox -> {
            if (checkbox.selected()) {
                DialogDataSet dialogDataSet = new DialogDataSet(DialogType.NONE);
                NetworkMessageHandlerManager.getServerHandler().saveDialogSet(this.getEasyNPCUUID(), dialogDataSet);
            } else if (formerDialogDataSet != null && formerDialogDataSet.hasDialog()) {
                NetworkMessageHandlerManager.getServerHandler().saveDialogSet(this.getEasyNPCUUID(), formerDialogDataSet);
            } else {
                DialogDataSet dialogDataSet = new DialogDataSet(DialogType.BASIC);
                NetworkMessageHandlerManager.getServerHandler().saveDialogSet(this.getEasyNPCUUID(), dialogDataSet);
            }
        }));
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.f_96547_);
                Text.drawString(guiGraphics, this.f_96547_, formattedCharSequence, this.leftPos + 15, this.topPos + 60 + line * (9 + 2));
            }
        }
    }
}

