/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.custom.FairyModel;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseHumanoidMobModelRenderer;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.Fairy;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class FairyModelRenderer
extends BaseHumanoidMobModelRenderer<Fairy, Fairy.Variant, FairyModel<Fairy>> {
    protected static final Map<Fairy.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(Fairy.Variant.class), map -> {
        map.put(Fairy.Variant.BLUE, new ResourceLocation("easy_npc", "textures/entity/fairy/fairy_blue.png"));
        map.put(Fairy.Variant.GREEN, new ResourceLocation("easy_npc", "textures/entity/fairy/fairy_green.png"));
        map.put(Fairy.Variant.RED, new ResourceLocation("easy_npc", "textures/entity/fairy/fairy_red.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Fairy.Variant.GREEN);

    public FairyModelRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, new FairyModel(context.m_174023_(modelLayerLocation)), 0.3f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
    }

    @Override
    public <N extends EasyNPC<Fairy>> void rotateEntity(N easyNPC, PoseStack poseStack) {
        CustomRotation rootRotation = easyNPC.getEasyNPCModelData().getModelRootRotation();
        if (rootRotation != null) {
            poseStack.m_85837_(0.0, 0.5, 0.0);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(rootRotation.x()));
            poseStack.m_252781_(Axis.f_252436_.m_252961_(rootRotation.y()));
            poseStack.m_252781_(Axis.f_252403_.m_252961_(rootRotation.z()));
            poseStack.m_85837_(0.0, -0.5, 0.0);
        }
    }

    @Override
    public void renderDefaultPose(Fairy entity, FairyModel<Fairy> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.m_85837_(-0.5, 0.0, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(this.m_6441_((LivingEntity)entity)));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                model.m_5585_().f_104203_ = -0.7853982f;
                model.m_5585_().f_104204_ = -0.7853982f;
                model.m_5585_().f_104205_ = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                model.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                model.f_102816_ = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.m_85837_(0.5, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                model.f_102815_ = HumanoidModel.ArmPose.BLOCK;
                model.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-35.0f));
                break;
            }
            default: {
                model.f_102815_ = HumanoidModel.ArmPose.EMPTY;
                model.f_102816_ = HumanoidModel.ArmPose.EMPTY;
                model.m_5585_().f_104203_ = 0.0f;
                model.m_5585_().f_104204_ = 0.0f;
                model.m_5585_().f_104205_ = 0.0f;
            }
        }
    }
}

