/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer;

import de.markusbordihn.easynpc.client.model.ModModelLayers;
import de.markusbordihn.easynpc.client.renderer.entity.custom.FairyModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.custom.OrcModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.layers.CustomHumanoidArmorLayer;
import de.markusbordihn.easynpc.client.renderer.entity.raw.PiglinRawRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.raw.SkeletonRawRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.raw.ZombieRawRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.AllayModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.CatModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.ChickenModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.HorseModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.HumanoidModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.HumanoidSlimModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.IllagerModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.IronGolemModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.PigModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.PiglinModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.SkeletonModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.VillagerModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.WolfModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.ZombieModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.standard.ZombieVillagerModelRenderer;
import de.markusbordihn.easynpc.compat.CompatConstants;
import de.markusbordihn.easynpc.entity.ModEntityType;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientRenderer {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private ClientRenderer() {
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        log.info("{} Entity Renders ...", (Object)"\ud83d\udde3 Register Easy NPC");
        event.registerEntityRenderer((EntityType)ModEntityType.ALLAY.get(), context -> new AllayModelRenderer(context, ModModelLayers.ALLAY));
        event.registerEntityRenderer((EntityType)ModEntityType.CAT.get(), CatModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.CHICKEN.get(), ChickenModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.DROWNED.get(), context -> new ZombieModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.FAIRY.get(), context -> new FairyModelRenderer(context, ModModelLayers.FAIRY));
        event.registerEntityRenderer((EntityType)ModEntityType.HUMANOID.get(), context -> new HumanoidModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.HUMANOID_SLIM.get(), context -> new HumanoidSlimModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.STRAY.get(), context -> new SkeletonModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.WITHER_SKELETON.get(), context -> new SkeletonModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.HUSK.get(), context -> new ZombieModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.IRON_GOLEM.get(), IronGolemModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.SKELETON.get(), context -> new SkeletonModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.VILLAGER.get(), VillagerModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.ZOMBIE.get(), context -> new ZombieModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.ZOMBIE_VILLAGER.get(), context -> new ZombieVillagerModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.PIG.get(), PigModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.PIGLIN.get(), context -> new PiglinModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.PIGLIN_BRUTE.get(), context -> new PiglinModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.PIGLIN_ZOMBIFIED.get(), context -> new PiglinModelRenderer(context, CustomHumanoidArmorLayer.class));
        event.registerEntityRenderer((EntityType)ModEntityType.EVOKER.get(), IllagerModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.ILLUSIONER.get(), IllagerModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.PILLAGER.get(), IllagerModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.VINDICATOR.get(), IllagerModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.ORC.get(), context -> new OrcModelRenderer(context, ModModelLayers.ORC));
        event.registerEntityRenderer((EntityType)ModEntityType.ORC_WARRIOR.get(), context -> new OrcModelRenderer(context, ModModelLayers.ORC));
        event.registerEntityRenderer((EntityType)ModEntityType.WOLF.get(), WolfModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.HORSE.get(), HorseModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.SKELETON_HORSE.get(), HorseModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.ZOMBIE_HORSE.get(), HorseModelRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.PIGLIN_RAW.get(), context -> new PiglinRawRenderer(context, ModelLayers.f_171206_, ModelLayers.f_171158_, ModelLayers.f_171159_, false));
        event.registerEntityRenderer((EntityType)ModEntityType.SKELETON_RAW.get(), SkeletonRawRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityType.ZOMBIE_RAW.get(), ZombieRawRenderer::new);
        if (CompatConstants.MOD_EPIC_FIGHT_LOADED) {
            event.registerEntityRenderer((EntityType)ModEntityType.EPIC_FIGHT_ZOMBIE.get(), ZombieRawRenderer::new);
        }
    }
}

