/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.util;

import com.mojang.serialization.Codec;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.regions_unexplored.RegionsUnexploredMod;
import net.regions_unexplored.mixin.access.BiomeSourceAccess;
import net.regions_unexplored.mixin.access.NoiseBasedChunkGeneratorAccess;
import net.regions_unexplored.mixin.access.NoiseGeneratorSettingsAccess;

public class AddSurfaceRuleUtil {
    public static void appendSurfaceRule(RegistryAccess registryAccess, ResourceKey<LevelStem> levelStemKey, SurfaceRules.RuleSource ruleSource) {
        LevelStem levelStem = (LevelStem)registryAccess.m_175515_(Registries.f_256862_).m_6246_(levelStemKey);
        if (levelStem == null) {
            RegionsUnexploredMod.LOGGER.info("Error, LevelStem is somehow empty. Fix this!! >:(");
            return;
        }
        ChunkGenerator chunkGenerator = levelStem.f_63976_();
        boolean hasRegionsUnexploredBiome = chunkGenerator.m_62218_().m_207840_().stream().anyMatch(biomeHolder -> ((ResourceKey)biomeHolder.m_203543_().orElseThrow()).m_135782_().m_135827_().equals("regions_unexplored"));
        if (hasRegionsUnexploredBiome) {
            if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)((NoiseBasedChunkGeneratorAccess)chunkGenerator).regions_unexplored$getNoiseGeneratorSettings().m_203334_();
                if (levelStemKey == LevelStem.f_63972_) {
                    ((NoiseGeneratorSettingsAccess)noiseGeneratorSettings).regions_unexplored$setSurfaceRule(SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ruleSource, RegionsUnexploredMod.getSurfaceRules(noiseGeneratorSettings.f_188871_())}));
                } else {
                    ((NoiseGeneratorSettingsAccess)noiseGeneratorSettings).regions_unexplored$setSurfaceRule(SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ruleSource, noiseGeneratorSettings.f_188871_()}));
                }
            } else {
                RegionsUnexploredMod.LOGGER.info(String.format("Ignoring Region Unexplored appended surface rule in dimension: \"%s\" because the chunk generator was not an instance of \"NoiseBasedChunkGenerator\".\nThe chunk generator was an instanceof \"%s\".", levelStemKey.m_135782_(), chunkGenerator.getClass().getName()));
            }
        }
        Codec<? extends BiomeSource> biomeSourceCodec = ((BiomeSourceAccess)chunkGenerator.m_62218_()).regions_unexplored$invokeCodec();
        RegionsUnexploredMod.LOGGER.info(String.format("Loading dimension \"%s\" with biome source: \"%s\".", levelStemKey.m_135782_(), BuiltInRegistries.f_256737_.m_7981_(biomeSourceCodec).toString()));
    }
}

