/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outer_end.client.model;

import blueduck.outer_end.entity.Stalker;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class StalkerModel<T extends Stalker>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("outer_end", "stalkermodel"), "main");
    private final ModelPart rearFootLeft;
    private final ModelPart rearFootRight;
    private final ModelPart haunchLeft;
    private final ModelPart haunchRight;
    private final ModelPart body;
    private final ModelPart frontLegLeft;
    private final ModelPart frontLegRight;
    private final ModelPart head;
    private final ModelPart tail;
    private final ModelPart getHead;

    public StalkerModel(ModelPart root) {
        this.rearFootLeft = root.m_171324_("rearFootLeft");
        this.rearFootRight = root.m_171324_("rearFootRight");
        this.haunchLeft = root.m_171324_("haunchLeft");
        this.haunchRight = root.m_171324_("haunchRight");
        this.body = root.m_171324_("body");
        this.frontLegLeft = root.m_171324_("frontLegLeft");
        this.frontLegRight = root.m_171324_("frontLegRight");
        this.head = root.m_171324_("head");
        this.tail = root.m_171324_("tail");
        this.getHead = root.m_171324_("getHead");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition rearFootLeft = partdefinition.m_171599_("rearFootLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)17.5f, (float)3.7f));
        PartDefinition rearFootRight = partdefinition.m_171599_("rearFootRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)17.5f, (float)3.7f));
        PartDefinition haunchLeft = partdefinition.m_171599_("haunchLeft", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-1.75f, -2.2576f, -4.5f, 3.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(79, 61).m_171488_(-0.75f, 9.7424f, -0.5f, 2.0f, 17.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.25f, (float)-3.2424f, (float)3.2f));
        PartDefinition haunchRight = partdefinition.m_171599_("haunchRight", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-1.25f, -2.25f, -4.5f, 3.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(79, 61).m_171488_(-1.25f, 9.75f, -0.5f, 2.0f, 17.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.25f, (float)-3.2424f, (float)2.851f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.637f, -24.1599f, 7.0f, 6.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(0, 26).m_171488_(-1.0f, -6.5762f, -24.8545f, 1.0f, 2.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)6.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition frontLegLeft = partdefinition.m_171599_("frontLegLeft", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-3.25f, -2.0f, -2.5f, 3.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.75f, (float)-5.0f, (float)-12.5f));
        PartDefinition bone4 = frontLegLeft.m_171599_("bone4", CubeListBuilder.m_171558_().m_171514_(80, 61).m_171488_(-1.0f, 0.5f, -2.0f, 2.0f, 17.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.75f, (float)11.5f, (float)1.5f));
        PartDefinition frontLegRight = partdefinition.m_171599_("frontLegRight", CubeListBuilder.m_171558_().m_171514_(1, 26).m_171488_(1.0f, -1.6947f, -2.4933f, 3.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-5.0f, (float)-12.5f));
        PartDefinition bone = frontLegRight.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(80, 61).m_171488_(-1.0f, 0.5f, -2.0f, 2.0f, 17.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)11.8053f, (float)1.5067f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(25, 26).m_171488_(-2.0f, -5.0f, -4.8333f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, -3.0f, -5.9333f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-7.0f, (float)-17.1667f));
        PartDefinition bone2 = head.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(45, 18).m_171488_(-1.0f, -1.0f, -1.5f, 2.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)-1.3333f, (float)0.1309f, (float)0.0f, (float)-0.0436f));
        PartDefinition tail = partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(29, 32).m_171488_(-1.6667f, -0.8172f, -1.5857f, 3.0f, 5.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(34, 0).m_171488_(-0.6667f, -1.3681f, -1.3432f, 1.0f, 1.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.3333f, (float)-3.9352f, (float)3.0711f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition bone3 = tail.m_171599_("bone3", CubeListBuilder.m_171558_().m_171514_(0, 49).m_171488_(-0.5f, -2.0f, -0.5f, 1.0f, 4.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.1667f, (float)1.6021f, (float)15.1508f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition getHead = partdefinition.m_171599_("getHead", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.frontLegRight.f_104203_ = (float)(Math.sin(limbSwing / 2.0f) * (double)(limbSwingAmount / 2.0f));
        this.frontLegLeft.f_104203_ = -this.frontLegRight.f_104203_;
        this.haunchRight.f_104203_ = -this.frontLegRight.f_104203_;
        this.haunchLeft.f_104203_ = this.frontLegRight.f_104203_;
        this.tail.f_104203_ = (float)(Math.toRadians(-27.5) + Math.sin(ageInTicks / 16.0f) / 32.0);
        this.tail.f_104203_ += (float)(Math.sin(limbSwing / 4.0f) * (double)(limbSwingAmount / 16.0f));
        this.tail.m_171324_((String)"bone3").f_104203_ = (float)((double)this.tail.f_104203_ - Math.toRadians(-20.5)) * 2.0f;
        this.head.f_104203_ = (float)Math.toRadians(headPitch + 12.0f);
        this.head.f_104204_ = (float)Math.toRadians(netHeadYaw);
        float wanted = entity.m_21660_() ? (float)(Math.cos(ageInTicks / 24.0f) * Math.toRadians(10.0) + Math.toRadians(70.0)) - this.head.f_104203_ : (float)(Math.cos(ageInTicks / 32.0f) * 0.25 + Math.toRadians(15.0)) - this.head.f_104203_;
        float delta = wanted - this.head.m_171324_((String)"bone2").f_104203_;
        if ((double)Math.abs(delta) < Math.toRadians(2.0)) {
            this.head.m_171324_((String)"bone2").f_104203_ = wanted;
        } else {
            float damp = 0.5f;
            delta = Math.min(delta * damp, (float)Math.toRadians(0.5));
            this.head.m_171324_((String)"bone2").f_104203_ += delta;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.rearFootLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rearFootRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.haunchLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.haunchRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontLegLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontLegRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.getHead.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

