/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.storage.FluidStorageType;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IAccessType;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IPrioritizable;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import com.refinedmods.refinedstorage.blockentity.data.RSSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FluidStorageBlockEntity
extends NetworkNodeBlockEntity<FluidStorageNetworkNode> {
    public static final BlockEntitySynchronizationParameter<Integer, FluidStorageBlockEntity> PRIORITY = IPrioritizable.createParameter(new ResourceLocation("refinedstorage", "fluid_storage_priority"));
    public static final BlockEntitySynchronizationParameter<Integer, FluidStorageBlockEntity> COMPARE = IComparable.createParameter(new ResourceLocation("refinedstorage", "fluid_storage_compare"));
    public static final BlockEntitySynchronizationParameter<Integer, FluidStorageBlockEntity> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter(new ResourceLocation("refinedstorage", "fluid_storage_whitelist_blacklist"));
    public static final BlockEntitySynchronizationParameter<AccessType, FluidStorageBlockEntity> ACCESS_TYPE = IAccessType.createParameter(new ResourceLocation("refinedstorage", "fluid_storage_access_type"));
    public static final BlockEntitySynchronizationParameter<Long, FluidStorageBlockEntity> STORED = new BlockEntitySynchronizationParameter<Long, FluidStorageBlockEntity>(new ResourceLocation("refinedstorage", "fluid_storage_stored"), RSSerializers.LONG_SERIALIZER, 0L, t -> ((FluidStorageNetworkNode)t.getNode()).getStorage() != null ? (long)((FluidStorageNetworkNode)t.getNode()).getStorage().getStored() : 0L);
    public static BlockEntitySynchronizationSpec SPEC = BlockEntitySynchronizationSpec.builder().addWatchedParameter(REDSTONE_MODE).addWatchedParameter(PRIORITY).addWatchedParameter(COMPARE).addWatchedParameter(WHITELIST_BLACKLIST).addWatchedParameter(STORED).addWatchedParameter(ACCESS_TYPE).build();
    private final FluidStorageType type;

    public FluidStorageBlockEntity(FluidStorageType type, BlockPos pos, BlockState state) {
        super(FluidStorageBlockEntity.getType(type), pos, state, SPEC, FluidStorageNetworkNode.class);
        this.type = type;
    }

    public static BlockEntityType<FluidStorageBlockEntity> getType(FluidStorageType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FluidStorageType.SIXTY_FOUR_K -> (BlockEntityType)RSBlockEntities.SIXTY_FOUR_K_FLUID_STORAGE_BLOCK.get();
            case FluidStorageType.TWO_HUNDRED_FIFTY_SIX_K -> (BlockEntityType)RSBlockEntities.TWO_HUNDRED_FIFTY_SIX_K_FLUID_STORAGE_BLOCK.get();
            case FluidStorageType.THOUSAND_TWENTY_FOUR_K -> (BlockEntityType)RSBlockEntities.THOUSAND_TWENTY_FOUR_K_FLUID_STORAGE_BLOCK.get();
            case FluidStorageType.FOUR_THOUSAND_NINETY_SIX_K -> (BlockEntityType)RSBlockEntities.FOUR_THOUSAND_NINETY_SIX_K_FLUID_STORAGE_BLOCK.get();
            case FluidStorageType.CREATIVE -> (BlockEntityType)RSBlockEntities.CREATIVE_FLUID_STORAGE_BLOCK.get();
        };
    }

    public FluidStorageType getFluidStorageType() {
        return this.type;
    }

    @Override
    @Nonnull
    public FluidStorageNetworkNode createNode(Level level, BlockPos pos) {
        return new FluidStorageNetworkNode(level, pos, this.type);
    }
}

