/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.gen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.wanmine.wab.init.gen.assets.WabBlockStateGenerator;
import net.wanmine.wab.init.gen.assets.WabItemGenerator;
import net.wanmine.wab.init.gen.assets.WabSoundsGenerator;
import net.wanmine.wab.init.gen.data.WabLootTableGenerator;
import net.wanmine.wab.init.gen.data.WabRecipeGenerator;
import net.wanmine.wab.init.gen.data.tag.WabBiomeTagGenerator;
import net.wanmine.wab.init.gen.data.tag.WabBlockTagGenerator;
import net.wanmine.wab.init.gen.data.tag.WabDamageTagGenerator;
import net.wanmine.wab.init.gen.data.tag.WabEntityTagGenerator;
import net.wanmine.wab.init.gen.data.tag.WabItemTagGenerator;
import net.wanmine.wab.init.gen.data.tag.WabStructureTagGenerator;

@Mod.EventBusSubscriber(modid="wan_ancient_beasts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WabGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new WabRecipeGenerator(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new WabSoundsGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)WabLootTableGenerator.create(packOutput));
        WabBlockTagGenerator blockTagGenerator = (WabBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new WabBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new WabItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new WabEntityTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new WabBiomeTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new WabStructureTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new WabDamageTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new WabBlockStateGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new WabItemGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new WabLootTableGenerator.PostProcessor(packOutput));
    }
}

