/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer;

import bre2el.fpsreducer.util.Logger;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    private boolean hasOptifine;
    private boolean hasOptiFabric;

    private boolean hasClass(String name) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name.replace('.', '/') + ".class");
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public void onLoad(String mixinPackage) {
        if (this.hasClass("optifine.OptiFineForgeTweaker")) {
            Logger.info("OptiFine was detected.");
            this.hasOptifine = true;
        } else {
            Logger.info("OptiFine was NOT detected.");
            this.hasOptifine = false;
        }
        if (this.hasClass("me.modmuss50.optifabric.mod.OptifabricSetup")) {
            Logger.info("OptiFabric was detected.");
            this.hasOptiFabric = true;
        } else {
            Logger.info("OptiFabric was NOT detected.");
            this.hasOptiFabric = false;
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.endsWith("WindowMixin") && !this.hasOptifine && !this.hasOptiFabric) {
            Logger.info(mixinClassName + " will NOT be applied because OptiFine was NOT detected.");
            return false;
        }
        Logger.info(mixinClassName + " will be applied.");
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

