/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.nature;

import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;

@AutoSpellConfig
public class VenomousRiftSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "venomous_rift");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.NATURE_RESOURCE).setMaxLevel(3).setCooldownSeconds(30.0).build();

    public VenomousRiftSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 50;
        this.baseManaCost = 60;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_SPIT_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SPIT_FINISH_ANIMATION;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ModSounds.MONSTROSITYGROWL.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.MONSTROSITYSHOOT.get());
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
        int radius = (int)(12.0f + this.getSpellPower(spellLevel, (Entity)entity) * 2.0f);
        int innerRadius = 6;
        int edgeMargin = 2;
        int depth = 2;
        BlockPos entityPos = entity.m_20183_();
        Random random = new Random();
        for (int angle = 0; angle < 360; angle += 10) {
            double radians = Math.toRadians(angle);
            int xOffset = (int)((double)radius * Math.cos(radians));
            int zOffset = (int)((double)radius * Math.sin(radians));
            for (int step = innerRadius; step <= radius - edgeMargin; ++step) {
                int x = entityPos.m_123341_() + (int)((double)step * Math.cos(radians)) + random.nextInt(3) - 1;
                int z = entityPos.m_123343_() + (int)((double)step * Math.sin(radians)) + random.nextInt(3) - 1;
                BlockPos targetPos = new BlockPos(x, entityPos.m_123342_() - 1, z);
                BlockState targetBlockState = level.m_8055_(targetPos);
                if (!targetBlockState.m_280296_() || !(targetBlockState.m_60800_((BlockGetter)level, targetPos) <= 4.0f)) continue;
                for (int d = 0; d < depth - 1; ++d) {
                    level.m_7731_(targetPos.m_6625_(d), Blocks.f_50016_.m_49966_(), 3);
                }
                BlockState newBlockState = random.nextInt(100) < 20 ? ((Block)ACBlockRegistry.ACIDIC_RADROCK.get()).m_49966_() : ((LiquidBlock)ACBlockRegistry.ACID.get()).m_49966_();
                level.m_7731_(targetPos.m_6625_(depth - 1), newBlockState, 3);
            }
        }
        for (int i = 0; i < 75; ++i) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double distance = (double)innerRadius + (double)(radius - innerRadius) * random.nextDouble();
            double x = (double)entityPos.m_123341_() + distance * Math.cos(angle);
            double z = (double)entityPos.m_123343_() + distance * Math.sin(angle);
            double y = entityPos.m_123342_();
            MagicManager.spawnParticles((Level)level, (ParticleOptions)((ParticleOptions)ACParticleRegistry.RAYGUN_EXPLOSION.get()), (double)x, (double)y, (double)z, (int)1, (double)0.0, (double)0.5, (double)0.0, (double)0.05, (boolean)true);
            MagicManager.spawnParticles((Level)level, (ParticleOptions)((ParticleOptions)ACParticleRegistry.GREEN_VENT_SMOKE.get()), (double)x, (double)y, (double)z, (int)1, (double)0.0, (double)0.5, (double)0.0, (double)0.05, (boolean)true);
        }
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        int radius = (int)(12.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f);
        int depth = 2;
        return List.of(Component.m_237110_((String)"ui.traveloptics.radius", (Object[])new Object[]{radius}), Component.m_237110_((String)"ui.traveloptics.depth", (Object[])new Object[]{depth}));
    }
}

