/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.lightning;

import com.gametechbc.traveloptics.api.particle.CylinderParticleManager;
import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.api.spells.AbstractUniqueSpell;
import com.gametechbc.traveloptics.api.utils.SummonCheckHelper;
import com.gametechbc.traveloptics.config.SpellsConfig;
import com.gametechbc.traveloptics.entity.summons.SummonedTheProwler;
import com.gametechbc.traveloptics.entity.summons.SummonedTheWatcher;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.util.SummonTypes;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class MechanizedPredatorSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "mechanized_predator");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.LIGHTNING_RESOURCE).setMaxLevel(5).setCooldownSeconds(540.0).build();

    public MechanizedPredatorSpell() {
        this.manaCostPerLevel = 100;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 80;
        this.baseManaCost = 100;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ModSounds.HARBINGER_CHARGE_PREPARE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.WATCHER_DEATH.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)SpellsConfig.limitGroupSummons.get()).booleanValue() && SummonCheckHelper.hasActiveSummons(player, 128.0, SummonTypes.getGroupSummons())) {
                player.m_5661_((Component)Component.m_237115_((String)"spell.traveloptics.summon_group.warning").m_130940_(ChatFormatting.RED), true);
                return false;
            }
        }
        return true;
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        CylinderParticleManager.spawnParticles(level, (Entity)entity, 1, (ParticleOptions)ACParticleRegistry.MAGNET_LIGHTNING.get(), ParticleDirection.UPWARD, 2.0, 1.0, 0.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTime = 12000;
        int koboletonCount = (int)this.getWatcherCount(spellLevel);
        double radius = 3.5;
        double angleIncrement = Math.PI * 2 / (double)koboletonCount;
        for (int i = 0; i < koboletonCount; ++i) {
            double angle = (double)i * angleIncrement;
            double xOffset = radius * Math.cos(angle);
            double zOffset = radius * Math.sin(angle);
            SummonedTheWatcher watcher = new SummonedTheWatcher(world, entity);
            watcher.m_6034_(entity.m_20185_() + xOffset, entity.m_20186_(), entity.m_20189_() + zOffset);
            watcher.m_21204_().m_22146_(Attributes.f_22281_).m_22100_((double)this.getWatcherDamage(spellLevel, entity));
            watcher.m_21204_().m_22146_(Attributes.f_22276_).m_22100_((double)this.getWatcherHealth(spellLevel));
            watcher.m_21153_(watcher.m_21233_());
            world.m_7967_((Entity)watcher);
            watcher.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.MECHANIZED_PREDATOR_TIMER.get(), summonTime, 0, false, false, false));
            MagicManager.spawnParticles((Level)world, (ParticleOptions)((ParticleOptions)ACParticleRegistry.MAGNET_LIGHTNING.get()), (double)(entity.m_20185_() + xOffset), (double)entity.m_20186_(), (double)(entity.m_20189_() + zOffset), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
        }
        SummonedTheProwler prowler = new SummonedTheProwler(world, entity);
        prowler.m_146884_(entity.m_20182_());
        prowler.m_21204_().m_22146_(Attributes.f_22281_).m_22100_((double)this.getProwlerDamage(spellLevel, entity));
        prowler.m_21204_().m_22146_(Attributes.f_22276_).m_22100_((double)this.getProwlerHealth(spellLevel));
        prowler.m_21153_(prowler.m_21233_());
        world.m_7967_((Entity)prowler);
        prowler.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.MECHANIZED_PREDATOR_TIMER.get(), summonTime, 0, false, false, false));
        MagicManager.spawnParticles((Level)world, (ParticleOptions)((ParticleOptions)ACParticleRegistry.SCARLET_SHIELD_LIGHTNING.get()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
        int effectAmplifier = 0;
        if (entity.m_21023_((MobEffect)TravelopticsEffects.MECHANIZED_PREDATOR_TIMER.get())) {
            effectAmplifier += entity.m_21124_((MobEffect)TravelopticsEffects.MECHANIZED_PREDATOR_TIMER.get()).m_19564_() + 1;
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.MECHANIZED_PREDATOR_TIMER.get(), summonTime, effectAmplifier, false, false, true));
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(35, entity.m_20182_(), 25.0f));
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float getWatcherCount(int spellLevel) {
        return spellLevel;
    }

    private float getWatcherHealth(int spellLevel) {
        return (float)spellLevel * 5.0f;
    }

    private float getWatcherDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = this.getSpellPower(spellLevel, (Entity)caster);
        double summonedDamageMultiplier = 1.0;
        if (caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get())) {
            summonedDamageMultiplier = caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get());
        }
        return (float)((double)baseDamage * summonedDamageMultiplier);
    }

    private String getWatcherDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = this.getSpellPower(spellLevel, (Entity)caster);
            double summonedDamageMultiplier = caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) ? caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) : 1.0;
            float finalDamage = (float)((double)baseDamage * summonedDamageMultiplier);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (summonedDamageMultiplier > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    private float getProwlerHealth(int spellLevel) {
        return 60.0f + (float)spellLevel * 20.0f;
    }

    private float getProwlerDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = 5.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
        double summonedDamageMultiplier = 1.0;
        if (caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get())) {
            summonedDamageMultiplier = caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get());
        }
        return (float)((double)baseDamage * summonedDamageMultiplier);
    }

    private String getProwlerDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = 5.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
            double summonedDamageMultiplier = caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) ? caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) : 1.0;
            float finalDamage = (float)((double)baseDamage * summonedDamageMultiplier);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (summonedDamageMultiplier > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.summon_count", (Object[])new Object[]{Float.valueOf(this.getWatcherCount(spellLevel) + 1.0f)}), Component.m_237110_((String)"ui.traveloptics.watcher_hp", (Object[])new Object[]{Float.valueOf(this.getWatcherHealth(spellLevel))}), Component.m_237110_((String)"ui.traveloptics.watcher_damage", (Object[])new Object[]{this.getWatcherDamageText(spellLevel, caster)}), Component.m_237110_((String)"ui.traveloptics.prowler_hp", (Object[])new Object[]{Float.valueOf(this.getProwlerHealth(spellLevel))}), Component.m_237110_((String)"ui.traveloptics.prowler_damage", (Object[])new Object[]{this.getProwlerDamageText(spellLevel, caster)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }
}

