/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.network;

import com.gametechbc.traveloptics.api.utils.ClientBossScreenHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class OpenBossScreenPacket {
    private final String bossRegistryKey;
    private final int entityId;

    public OpenBossScreenPacket(String bossRegistryKey, int entityId) {
        this.bossRegistryKey = bossRegistryKey;
        this.entityId = entityId;
    }

    public OpenBossScreenPacket(FriendlyByteBuf buf) {
        this.bossRegistryKey = buf.m_130277_();
        this.entityId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.bossRegistryKey);
        buf.writeInt(this.entityId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientBossScreenHelper.openBossScreen(this.bossRegistryKey, this.entityId));
        context.setPacketHandled(true);
        return true;
    }
}

