/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.bossweapon.galenic_polarizer;

import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.config.WeaponConfig;
import com.gametechbc.traveloptics.data_manager.GalenaChargeManager;
import com.gametechbc.traveloptics.entity.item.galenic_polarizer.GalenicPolarizerRenderer;
import com.gametechbc.traveloptics.entity.misc.TOScreenShakeEntity;
import com.gametechbc.traveloptics.entity.misc.stack_entity.StackEntity;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.item.UnbreakableGeoMagicSword;
import com.github.L_Ender.cataclysm.client.particle.CircleLightningParticle;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class GalenicPolarizerItem
extends UnbreakableGeoMagicSword {
    public static final String AZURE_CHARGED_STACK = "azure_charged";
    public static final String SCARLET_CHARGED_STACK = "scarlet_charged";
    private static final int MAX_STACKS_PER_ENTITY = 30;
    private static final int AZURE_COLOR = 24815;
    private static final int SCARLET_COLOR = 16711722;
    private static ItemDisplayContext transformType;

    public GalenicPolarizerItem(SpellDataRegistryHolder[] imbuedSpells) {
        super(new Tier(){

            public int m_6609_() {
                return (Integer)WeaponConfig.galenicPolarizerDurability.get();
            }

            public float m_6624_() {
                return 2.0f;
            }

            public float m_6631_() {
                return 0.0f;
            }

            public int m_6604_() {
                return 1;
            }

            public int m_6601_() {
                return 20;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.IGNITIUM_INGOT.get())});
            }
        }, (Double)WeaponConfig.galenicPolarizerDamage.get(), (Double)WeaponConfig.galenicPolarizerAttackSpeed.get(), imbuedSpells, Map.of((Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get(), new AttributeModifier(UUID.fromString("71acbf2f-bf0c-46fe-8ea3-14d4b03ab121"), "Weapon Modifier", ((Double)WeaponConfig.galenicPolarizerLightningSpellPower.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE)), ItemPropertiesHelper.hidden((int)1).m_41497_(TravelopticsItems.RARITY_MAGNETIC));
    }

    protected int getMaxStacksPerUse() {
        return 10;
    }

    protected boolean shouldGrantBonusCharge(LivingEntity attacker) {
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.m_7579_(stack, target, attacker);
        if (!target.m_9236_().f_46443_) {
            this.applyMagneticCharge(stack, target, attacker);
        }
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (player != null && player.m_21205_() == stack && !player.m_9236_().f_46443_) {
            int azureCharge = GalenaChargeManager.getAzureCharge(stack);
            int scarletCharge = GalenaChargeManager.getScarletCharge(stack);
            if (azureCharge > 0 || scarletCharge > 0) {
                this.magneticFieldDischarge(context, azureCharge, scarletCharge);
                player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.EMP_ACTIVATED.get(), SoundSource.PLAYERS, 1.2f, 1.0f);
                TOScreenShakeEntity.createScreenShake(player.m_9236_(), player.m_20182_(), 12.0f, 0.018f, 10, 5, 0, false);
                player.m_36335_().m_41524_((Item)this, 140);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }

    private void applyMagneticCharge(ItemStack weaponStack, LivingEntity target, LivingEntity attacker) {
        boolean hasScarlet;
        int azureStacks = StackEntity.getStackCountFromEntity((Entity)target, AZURE_CHARGED_STACK);
        int scarletStacks = StackEntity.getStackCountFromEntity((Entity)target, SCARLET_CHARGED_STACK);
        boolean hasAzure = azureStacks > 0;
        boolean bl = hasScarlet = scarletStacks > 0;
        if (hasAzure) {
            if (azureStacks < 30) {
                StackEntity.addStacksToEntity((Entity)target, AZURE_CHARGED_STACK, 1, 24815, 0.5f);
                GalenaChargeManager.addAzureCharge(weaponStack, target, 1);
                if (this.shouldGrantBonusCharge(attacker)) {
                    GalenaChargeManager.addAzureCharge(weaponStack, target, 1);
                }
            }
        } else if (hasScarlet) {
            if (scarletStacks < 30) {
                StackEntity.addStacksToEntity((Entity)target, SCARLET_CHARGED_STACK, 1, 16711722, 0.5f);
                GalenaChargeManager.addScarletCharge(weaponStack, target, 1);
                if (this.shouldGrantBonusCharge(attacker)) {
                    GalenaChargeManager.addScarletCharge(weaponStack, target, 1);
                }
            }
        } else if (target.m_9236_().f_46441_.m_188499_()) {
            StackEntity.addStacksToEntity((Entity)target, AZURE_CHARGED_STACK, 1, 24815, 0.5f);
        } else {
            StackEntity.addStacksToEntity((Entity)target, SCARLET_CHARGED_STACK, 1, 16711722, 0.5f);
        }
    }

    private void magneticFieldDischarge(UseOnContext context, int azureCharge, int scarletCharge) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        ItemStack stack = context.m_43722_();
        Vec3 clickedPos = Vec3.m_82512_((Vec3i)context.m_8083_());
        assert (player != null);
        Vec3 blastwavePos = new Vec3(clickedPos.f_82479_, player.m_20186_(), clickedPos.f_82481_);
        double radius = 12.0;
        this.spawnRadiusBlastwave(world, blastwavePos, radius);
        List entities = world.m_6249_((Entity)player, new AABB(clickedPos.f_82479_ - radius, clickedPos.f_82480_ - radius, clickedPos.f_82481_ - radius, clickedPos.f_82479_ + radius, clickedPos.f_82480_ + radius, clickedPos.f_82481_ + radius), entity -> entity instanceof LivingEntity);
        if (entities.isEmpty()) {
            return;
        }
        int maxAzureUsed = 0;
        int maxScarletUsed = 0;
        int maxStacksPerUse = this.getMaxStacksPerUse();
        for (Entity entity2 : entities) {
            int toAdd;
            boolean shouldApplyAzure;
            int canAddTotal;
            int canAddThisUse;
            int toAdd2;
            boolean hasScarlet;
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity2;
            int azureStacks = StackEntity.getStackCountFromEntity((Entity)target, AZURE_CHARGED_STACK);
            int scarletStacks = StackEntity.getStackCountFromEntity((Entity)target, SCARLET_CHARGED_STACK);
            boolean hasAzure = azureStacks > 0;
            boolean bl = hasScarlet = scarletStacks > 0;
            if (hasAzure) {
                if (azureCharge <= 0 || (toAdd2 = Math.min(canAddThisUse = Math.min(canAddTotal = 30 - azureStacks, maxStacksPerUse), azureCharge)) <= 0) continue;
                StackEntity.addStacksToEntity((Entity)target, AZURE_CHARGED_STACK, toAdd2, 24815, 0.5f);
                this.spawnLightningToTarget(world, clickedPos, target.m_20182_(), true);
                maxAzureUsed = Math.max(maxAzureUsed, toAdd2);
                continue;
            }
            if (hasScarlet) {
                if (scarletCharge <= 0 || (toAdd2 = Math.min(canAddThisUse = Math.min(canAddTotal = 30 - scarletStacks, maxStacksPerUse), scarletCharge)) <= 0) continue;
                StackEntity.addStacksToEntity((Entity)target, SCARLET_CHARGED_STACK, toAdd2, 16711722, 0.5f);
                this.spawnLightningToTarget(world, clickedPos, target.m_20182_(), false);
                maxScarletUsed = Math.max(maxScarletUsed, toAdd2);
                continue;
            }
            if (azureCharge > 0 && scarletCharge > 0) {
                shouldApplyAzure = world.f_46441_.m_188499_();
            } else {
                boolean bl2 = shouldApplyAzure = azureCharge > 0;
            }
            if (shouldApplyAzure && azureCharge > 0) {
                toAdd = Math.min(maxStacksPerUse, azureCharge);
                StackEntity.addStacksToEntity((Entity)target, AZURE_CHARGED_STACK, toAdd, 24815, 0.5f);
                this.spawnLightningToTarget(world, clickedPos, target.m_20182_(), true);
                maxAzureUsed = Math.max(maxAzureUsed, toAdd);
                continue;
            }
            if (shouldApplyAzure || scarletCharge <= 0) continue;
            toAdd = Math.min(maxStacksPerUse, scarletCharge);
            StackEntity.addStacksToEntity((Entity)target, SCARLET_CHARGED_STACK, toAdd, 16711722, 0.5f);
            this.spawnLightningToTarget(world, clickedPos, target.m_20182_(), false);
            maxScarletUsed = Math.max(maxScarletUsed, toAdd);
        }
        GalenaChargeManager.setAzureCharge(stack, azureCharge - maxAzureUsed);
        GalenaChargeManager.setScarletCharge(stack, scarletCharge - maxScarletUsed);
    }

    private void spawnRadiusBlastwave(Level world, Vec3 position, double radius) {
        Vector3f colorVec = TOGeneralUtils.hexToVector3f(0xE9EEFF);
        BlastwaveParticleOptions blastwaveOptions = new BlastwaveParticleOptions(colorVec, (float)radius);
        MagicManager.spawnParticles((Level)world, (ParticleOptions)blastwaveOptions, (double)position.f_82479_, (double)(position.f_82480_ + 0.1), (double)position.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
    }

    private void spawnLightningToTarget(Level world, Vec3 from, Vec3 to, boolean isAzure) {
        int color = isAzure ? 24815 : 16711722;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        MagicManager.spawnParticles((Level)world, (ParticleOptions)new CircleLightningParticle.CircleData(r, g, b), (double)from.f_82479_, (double)(from.f_82480_ + 0.5), (double)from.f_82481_, (int)0, (double)to.f_82479_, (double)(to.f_82480_ + 0.5), (double)to.f_82481_, (double)1.0, (boolean)true);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.galenic_polarizer.tooltip").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.galenic_polarizer.tooltip1"));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.galenic_polarizer.tooltip2"));
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)""));
        }
        int scarletCharge = GalenaChargeManager.getScarletCharge(stack);
        int azureCharge = GalenaChargeManager.getAzureCharge(stack);
        tooltip.add((Component)Component.m_237113_((String)"\u26a1 Galena Power: ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)("Scarlet " + scarletCharge)).m_130938_(style -> style.m_178520_(16711722))).m_7220_((Component)Component.m_237113_((String)" | ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("Azure " + azureCharge)).m_130938_(style -> style.m_178520_(24815))));
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution_benefits.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.galenic_polarizer.evo_one.inactive.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.galenic_polarizer.evo_two.inactive.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.galenic_polarizer.evo_three.inactive.tooltip"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution.stars_zero.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.shift_hold.advanced_tooltips"));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        super.m_7373_(stack, world, tooltip, flag);
    }

    public void getTransformType(ItemDisplayContext type) {
        transformType = type;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BlockEntityWithoutLevelRenderer getRenderer() {
        return new GalenicPolarizerRenderer();
    }
}

