/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api.render.screen;

import com.gametechbc.traveloptics.api.item.AbstractLoreItem;
import com.gametechbc.traveloptics.api.utils.GUIColorThemeBuilder;
import com.gametechbc.traveloptics.init.TravelopticsKeybinds;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class LoreScreenRenderer
extends Screen {
    private static final int MAX_TEXT_WIDTH = 435;
    private static final int PADDING = 24;
    private static final int LINE_HEIGHT = 11;
    private static final int TITLE_SPACING = 28;
    private static final int SUBTITLE_SPACING = 20;
    private static final int SECTION_SPACING = 10;
    private static final int PAGE_INDICATOR_HEIGHT = 20;
    private static final int PAGE_DOT_SIZE = 6;
    private static final int PAGE_DOT_SPACING = 10;
    private static final int PAGE_TOP_SPACING = 35;
    private static final int PAGE_CONTENT_OFFSET = 18;
    private static final int CREDITS_FIELD_SPACING = 15;
    private final ItemStack bookStack;
    private final AbstractLoreItem loreItem;
    private final GUIColorThemeBuilder colors;
    private int currentPage = 0;
    private float animationTime = 0.0f;
    private long lastFrameTime = 0L;
    private int targetPage = 0;
    private float pageTransitionProgress = 1.0f;
    private static final float PAGE_TURN_DURATION = 0.35f;

    public LoreScreenRenderer(ItemStack stack) {
        super((Component)Component.m_237119_());
        this.bookStack = stack;
        this.loreItem = (AbstractLoreItem)stack.m_41720_();
        this.colors = this.loreItem.getColorSet();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.currentPage = 0;
        this.targetPage = 0;
        this.pageTransitionProgress = 1.0f;
        this.lastFrameTime = System.currentTimeMillis();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int displayPage;
        long currentTime = System.currentTimeMillis();
        float deltaTime = 0.0f;
        if (this.lastFrameTime != 0L) {
            deltaTime = (float)(currentTime - this.lastFrameTime) / 1000.0f;
            this.animationTime += deltaTime;
        }
        this.lastFrameTime = currentTime;
        if (this.pageTransitionProgress < 1.0f) {
            this.pageTransitionProgress = Math.min(1.0f, this.pageTransitionProgress + deltaTime / 0.35f);
            if (this.pageTransitionProgress >= 1.0f) {
                this.currentPage = this.targetPage;
            }
        }
        this.m_280273_(graphics);
        AbstractLoreItem.LorePages lorePages = this.loreItem.getLorePages(this.bookStack);
        AbstractLoreItem.LoreCredits credits = this.loreItem.getLoreCredits(this.bookStack);
        int totalPages = lorePages.getTotalPages();
        if (credits != null) {
            ++totalPages;
        }
        this.currentPage = Mth.m_14045_((int)this.currentPage, (int)0, (int)totalPages);
        this.targetPage = Mth.m_14045_((int)this.targetPage, (int)0, (int)totalPages);
        graphics.m_280168_().m_85836_();
        this.applyPageTransitionEffects(graphics);
        int n = displayPage = this.pageTransitionProgress < 0.5f ? this.currentPage : this.targetPage;
        if (displayPage == 0) {
            this.renderPreviewPage(graphics);
        } else {
            this.renderContentPage(graphics, lorePages, credits, totalPages, displayPage);
        }
        graphics.m_280168_().m_85849_();
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        AbstractLoreItem.LorePages lorePages = this.loreItem.getLorePages(this.bookStack);
        AbstractLoreItem.LoreCredits credits = this.loreItem.getLoreCredits(this.bookStack);
        int totalPages = lorePages.getTotalPages();
        if (credits != null) {
            ++totalPages;
        }
        if (TravelopticsKeybinds.KEY_ARROW_RIGHT.m_90832_(keyCode, scanCode) && this.targetPage < totalPages) {
            ++this.targetPage;
            this.pageTransitionProgress = 0.0f;
            return true;
        }
        if (TravelopticsKeybinds.KEY_ARROW_LEFT.m_90832_(keyCode, scanCode) && this.targetPage > 0) {
            --this.targetPage;
            this.pageTransitionProgress = 0.0f;
            return true;
        }
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            AbstractLoreItem.LorePages lorePages = this.loreItem.getLorePages(this.bookStack);
            AbstractLoreItem.LoreCredits credits = this.loreItem.getLoreCredits(this.bookStack);
            int totalPages = lorePages.getTotalPages();
            if (credits != null) {
                ++totalPages;
            }
            if (this.targetPage < totalPages) {
                ++this.targetPage;
                this.pageTransitionProgress = 0.0f;
                return true;
            }
        } else if (button == 1 && this.targetPage > 0) {
            --this.targetPage;
            this.pageTransitionProgress = 0.0f;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }

    private void applyPageTransitionEffects(GuiGraphics graphics) {
        if (this.pageTransitionProgress >= 1.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        float t = this.pageTransitionProgress;
        float eased = (float)(1.0 - Math.cos((double)t * Math.PI)) / 2.0f;
        float fadeAlpha = t < 0.5f ? 1.0f - eased * 0.6f : 0.4f + (eased - 0.5f) * 1.2f;
        fadeAlpha = Math.max(0.4f, Math.min(1.0f, fadeAlpha));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)fadeAlpha);
    }

    private void renderPreviewPage(GuiGraphics graphics) {
        Component itemName = this.bookStack.m_41786_();
        AbstractLoreItem.LoreCredits credits = this.loreItem.getLoreCredits(this.bookStack);
        String author = credits != null && !credits.getLoreAuthor().isEmpty() ? credits.getLoreAuthor() : "";
        String subtitle = this.loreItem.getLoreSubtitle(this.bookStack);
        int screenWidth = 483;
        int screenHeight = 280;
        int screenX = (this.f_96543_ - screenWidth) / 2;
        int screenY = (this.f_96544_ - screenHeight) / 2;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 0.0f);
        this.renderBookBackground(graphics, screenX, screenY, screenWidth, screenHeight);
        this.renderBorders(graphics, screenX, screenY, screenWidth, screenHeight);
        this.renderParticles(graphics, screenX, screenY, screenWidth, screenHeight);
        this.renderCornerStars(graphics, this.f_96547_, screenX, screenY, screenWidth, screenHeight);
        int centerX = screenX + screenWidth / 2;
        int contentX = screenX + 24;
        int currentY = screenY + 24 + 30;
        float pulse = (Mth.m_14031_((float)(this.animationTime * 2.0f)) + 1.0f) / 2.0f;
        MutableComponent topOrnament = Component.m_237113_((String)"\u2756");
        int ornamentWidth = this.f_96547_.m_92852_((FormattedText)topOrnament);
        int ornamentAlpha = (int)(150.0f + pulse * 105.0f);
        int ornamentColor = ornamentAlpha << 24 | this.colors.borderHighlight & 0xFFFFFF;
        graphics.m_280614_(this.f_96547_, (Component)topOrnament, centerX - ornamentWidth / 2, currentY, ornamentColor, false);
        graphics.m_280168_().m_85836_();
        float titleScale = 1.5f;
        int titleWidth = (int)((float)this.f_96547_.m_92852_((FormattedText)itemName) * titleScale);
        graphics.m_280168_().m_252880_((float)(centerX - titleWidth / 2), (float)(currentY += 18), 0.0f);
        graphics.m_280168_().m_85841_(titleScale, titleScale, 1.0f);
        MutableComponent styledName = Component.m_237113_((String)itemName.getString()).m_130940_(ChatFormatting.ITALIC);
        int glowAlpha = (int)(50.0f + pulse * 70.0f);
        int glowColor = glowAlpha << 24 | this.colors.titleColor & 0xFFFFFF;
        for (int i = 2; i > 0; --i) {
            int layerAlpha = glowAlpha / (i + 1);
            int layerColor = layerAlpha << 24 | this.colors.titleColor & 0xFFFFFF;
            graphics.m_280614_(this.f_96547_, (Component)styledName, -i, -i, layerColor, false);
            graphics.m_280614_(this.f_96547_, (Component)styledName, i, -i, layerColor, false);
            graphics.m_280614_(this.f_96547_, (Component)styledName, -i, i, layerColor, false);
            graphics.m_280614_(this.f_96547_, (Component)styledName, i, i, layerColor, false);
        }
        graphics.m_280614_(this.f_96547_, (Component)styledName, 0, 0, this.colors.titleColor, false);
        graphics.m_280168_().m_85849_();
        Objects.requireNonNull(this.f_96547_);
        currentY += (int)(9.0f * titleScale) + 18;
        if (!subtitle.isEmpty()) {
            int ornamentMargin = 25;
            int ornamentY = currentY + 6;
            int subtitleWidth = (int)((float)this.f_96547_.m_92895_(subtitle) * 1.05f);
            int subtitleStartX = centerX - subtitleWidth / 2;
            int subtitleEndX = centerX + subtitleWidth / 2;
            this.renderOrnament(graphics, contentX, ornamentY, subtitleStartX - ornamentMargin);
            this.renderOrnament(graphics, subtitleEndX + ornamentMargin, ornamentY, contentX + 435);
            graphics.m_280168_().m_85836_();
            float subtitleScale = 1.05f;
            MutableComponent subtitleComp = Component.m_237113_((String)subtitle).m_130940_(ChatFormatting.ITALIC);
            graphics.m_280168_().m_252880_((float)(centerX - subtitleWidth / 2), (float)currentY, 0.0f);
            graphics.m_280168_().m_85841_(subtitleScale, subtitleScale, 1.0f);
            int subtitleGlow = (int)(35.0f + pulse * 45.0f);
            int subtitleGlowColor = subtitleGlow << 24 | this.colors.subtitleColor & 0xFFFFFF;
            graphics.m_280614_(this.f_96547_, (Component)subtitleComp, -1, -1, subtitleGlowColor, false);
            graphics.m_280614_(this.f_96547_, (Component)subtitleComp, 1, -1, subtitleGlowColor, false);
            graphics.m_280614_(this.f_96547_, (Component)subtitleComp, -1, 1, subtitleGlowColor, false);
            graphics.m_280614_(this.f_96547_, (Component)subtitleComp, 1, 1, subtitleGlowColor, false);
            graphics.m_280614_(this.f_96547_, (Component)subtitleComp, 0, 0, this.colors.subtitleColor, false);
            graphics.m_280168_().m_85849_();
            Objects.requireNonNull(this.f_96547_);
            currentY += (int)(9.0f * subtitleScale) + 22;
        }
        int lineWidth = 150;
        int lineAlpha = (int)(100.0f + pulse * 100.0f);
        int lineColor = lineAlpha << 24 | this.colors.borderAccent & 0xFFFFFF;
        for (int i = 0; i < lineWidth; i += 3) {
            float linePulse = (Mth.m_14031_((float)(this.animationTime * 1.5f + (float)i * 0.1f)) + 1.0f) / 2.0f;
            int dotAlpha = (int)(80.0f + linePulse * 120.0f);
            int dotColor = dotAlpha << 24 | this.colors.borderAccent & 0xFFFFFF;
            graphics.m_280509_(centerX - lineWidth / 2 + i, currentY, centerX - lineWidth / 2 + i + 1, currentY + 1, dotColor);
        }
        currentY += 20;
        if (!author.isEmpty()) {
            MutableComponent authorText = Component.m_237113_((String)"~ by ").m_130940_(ChatFormatting.ITALIC).m_7220_((Component)Component.m_237113_((String)author)).m_7220_((Component)Component.m_237113_((String)" ~").m_130940_(ChatFormatting.ITALIC));
            int authorWidth = this.f_96547_.m_92852_((FormattedText)authorText);
            graphics.m_280614_(this.f_96547_, (Component)authorText, centerX - authorWidth / 2, currentY, this.colors.textColor, false);
            Objects.requireNonNull(this.f_96547_);
            currentY += 9 + 25;
        } else {
            currentY += 15;
        }
        MutableComponent diamondIcon = Component.m_237113_((String)"\u25c6");
        graphics.m_280168_().m_85836_();
        float iconScale = 1.2f;
        int iconWidth = (int)((float)this.f_96547_.m_92852_((FormattedText)diamondIcon) * iconScale);
        graphics.m_280168_().m_252880_((float)(centerX - iconWidth / 2), (float)currentY, 0.0f);
        graphics.m_280168_().m_85841_(iconScale, iconScale, 1.0f);
        int iconAlpha = (int)(160.0f + pulse * 95.0f);
        int iconColor = iconAlpha << 24 | this.colors.borderHighlight & 0xFFFFFF;
        int iconGlow = 0x32000000 | this.colors.particleColor & 0xFFFFFF;
        graphics.m_280614_(this.f_96547_, (Component)diamondIcon, -2, -2, iconGlow, false);
        graphics.m_280614_(this.f_96547_, (Component)diamondIcon, 2, -2, iconGlow, false);
        graphics.m_280614_(this.f_96547_, (Component)diamondIcon, -2, 2, iconGlow, false);
        graphics.m_280614_(this.f_96547_, (Component)diamondIcon, 2, 2, iconGlow, false);
        graphics.m_280614_(this.f_96547_, (Component)diamondIcon, 0, 0, iconColor, false);
        graphics.m_280168_().m_85849_();
        MutableComponent prompt = Component.m_237115_((String)"lore_item.traveloptics.preview.continue.start").m_7220_(TravelopticsKeybinds.KEY_ARROW_RIGHT.m_90863_()).m_7220_((Component)Component.m_237115_((String)"lore_item.traveloptics.preview.continue.end")).m_130940_(ChatFormatting.ITALIC);
        int promptWidth = this.f_96547_.m_92852_((FormattedText)prompt);
        int promptAlpha = (int)(100.0f + pulse * 155.0f);
        int promptColor = promptAlpha << 24 | this.colors.borderHighlight & 0xFFFFFF;
        graphics.m_280614_(this.f_96547_, (Component)prompt, centerX - promptWidth / 2, currentY += 30, promptColor, false);
        graphics.m_280168_().m_85849_();
    }

    private void renderContentPage(GuiGraphics graphics, AbstractLoreItem.LorePages lorePages, AbstractLoreItem.LoreCredits credits, int totalPages, int displayPage) {
        boolean isCreditsPage = credits != null && displayPage == totalPages;
        ArrayList<WrappedParagraph> wrappedParagraphs = new ArrayList<WrappedParagraph>();
        if (!isCreditsPage) {
            List<String> paragraphs = lorePages.getPage(displayPage - 1);
            for (String paragraph : paragraphs) {
                wrappedParagraphs.add(this.wrapText(paragraph, this.f_96547_, 435));
            }
        }
        int contentHeight = isCreditsPage ? this.calculateCreditsHeight(credits) : this.calculateContentHeight(wrappedParagraphs, totalPages, displayPage);
        int tooltipWidth = 483;
        int tooltipHeight = contentHeight + 48;
        int tooltipX = (this.f_96543_ - tooltipWidth) / 2;
        int tooltipY = (this.f_96544_ - tooltipHeight) / 2;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 0.0f);
        this.renderBookBackground(graphics, tooltipX, tooltipY, tooltipWidth, tooltipHeight);
        this.renderBorders(graphics, tooltipX, tooltipY, tooltipWidth, tooltipHeight);
        this.renderParticles(graphics, tooltipX, tooltipY, tooltipWidth, tooltipHeight);
        this.renderCornerStars(graphics, this.f_96547_, tooltipX, tooltipY, tooltipWidth, tooltipHeight);
        int contentX = tooltipX + 24;
        int contentY = tooltipY + 24;
        if (isCreditsPage) {
            this.renderCreditsPage(graphics, this.f_96547_, credits, contentX, contentY, 435);
        } else if (displayPage == 1) {
            contentY += this.renderTitle(graphics, this.f_96547_, this.loreItem.getLoreTitle(this.bookStack), contentX, contentY, 435);
            contentY += this.renderSubtitle(graphics, this.f_96547_, this.loreItem.getLoreSubtitle(this.bookStack), contentX, contentY, 435);
            for (int i = 0; i < wrappedParagraphs.size(); ++i) {
                contentY += this.renderParagraph(graphics, this.f_96547_, (WrappedParagraph)wrappedParagraphs.get(i), contentX, contentY, i == 0, this.loreItem.getFirstWordMargin());
                contentY += 10;
            }
        } else {
            this.renderPageDecorator(graphics, this.f_96547_, contentX, contentY, 435);
            contentY += 18;
            for (WrappedParagraph para : wrappedParagraphs) {
                contentY += this.renderParagraph(graphics, this.f_96547_, para, contentX, contentY, false, 0);
                contentY += 10;
            }
        }
        if (displayPage > 0 && totalPages > 1) {
            this.renderPageIndicators(graphics, this.f_96547_, tooltipX, tooltipY + tooltipHeight - 24 - 10, tooltipWidth, displayPage, totalPages);
        }
        graphics.m_280168_().m_85849_();
    }

    private void renderBookBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        this.fillGradient(graphics, x - 8, y - 8, x + width + 8, y + height + 8, Integer.MIN_VALUE, 0x40000000);
        this.fillGradient(graphics, x - 4, y - 4, x + width + 4, y + height + 4, -1610612736, 0x60000000);
        graphics.m_280509_(x, y, x + width, y + height, this.colors.bgDark);
        this.fillGradient(graphics, x, y, x + width, y + height / 2, this.colors.bgBase, this.colors.bgDark);
        this.fillGradient(graphics, x, y + height / 2, x + width, y + height, this.colors.bgDark, this.colors.bgDark);
        int smoothWidth = width / 4;
        this.fillGradientHorizontal(graphics, x, y, x + smoothWidth, y + height, 0x30000000, 0);
        int vignetteSize = 25;
        this.fillGradient(graphics, x, y, x + width, y + vignetteSize, 0x30000000, 0);
        this.fillGradient(graphics, x, y + height - vignetteSize, x + width, y + height, 0, 0x30000000);
        this.fillGradientHorizontal(graphics, x + width - vignetteSize, y, x + width, y + height, 0, 0x30000000);
    }

    private void renderBorders(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280509_(x - 3, y - 3, x + width + 3, y - 2, this.colors.borderDark);
        graphics.m_280509_(x - 3, y + height + 2, x + width + 3, y + height + 3, this.colors.borderDark);
        graphics.m_280509_(x - 3, y - 2, x - 2, y + height + 2, this.colors.borderDark);
        graphics.m_280509_(x + width + 2, y - 2, x + width + 3, y + height + 2, this.colors.borderDark);
        graphics.m_280509_(x - 2, y - 2, x + width + 2, y - 1, this.colors.borderAccent);
        graphics.m_280509_(x - 2, y + height + 1, x + width + 2, y + height + 2, this.colors.borderAccent);
        graphics.m_280509_(x - 2, y - 1, x - 1, y + height + 1, this.colors.borderAccent);
        graphics.m_280509_(x + width + 1, y - 1, x + width + 2, y + height + 1, this.colors.borderAccent);
        graphics.m_280509_(x - 1, y - 1, x + width + 1, y, this.colors.borderHighlight);
        graphics.m_280509_(x - 1, y + height, x + width + 1, y + height + 1, this.colors.borderHighlight);
        graphics.m_280509_(x - 1, y, x, y + height, this.colors.borderHighlight);
        graphics.m_280509_(x + width, y, x + width + 1, y + height, this.colors.borderHighlight);
        int cornerSize = 12;
        int cornerThick = 2;
        graphics.m_280509_(x - 5, y - 5, x - 5 + cornerSize, y - 5 + cornerThick, this.colors.borderHighlight);
        graphics.m_280509_(x - 5, y - 5, x - 5 + cornerThick, y - 5 + cornerSize, this.colors.borderHighlight);
        graphics.m_280509_(x + width + 5 - cornerSize, y - 5, x + width + 5, y - 5 + cornerThick, this.colors.borderHighlight);
        graphics.m_280509_(x + width + 5 - cornerThick, y - 5, x + width + 5, y - 5 + cornerSize, this.colors.borderHighlight);
        graphics.m_280509_(x - 5, y + height + 5 - cornerThick, x - 5 + cornerSize, y + height + 5, this.colors.borderHighlight);
        graphics.m_280509_(x - 5, y + height + 5 - cornerSize, x - 5 + cornerThick, y + height + 5, this.colors.borderHighlight);
        graphics.m_280509_(x + width + 5 - cornerSize, y + height + 5 - cornerThick, x + width + 5, y + height + 5, this.colors.borderHighlight);
        graphics.m_280509_(x + width + 5 - cornerThick, y + height + 5 - cornerSize, x + width + 5, y + height + 5, this.colors.borderHighlight);
        float pulse = (Mth.m_14031_((float)(this.animationTime * 2.0f)) + 1.0f) / 2.0f;
        int accentAlpha = (int)(100.0f + pulse * 155.0f);
        int accentColor = accentAlpha << 24 | this.colors.particleColor & 0xFFFFFF;
        int accentWidth = 30;
        graphics.m_280509_(x + width / 2 - accentWidth / 2, y - 4, x + width / 2 + accentWidth / 2, y - 3, accentColor);
        graphics.m_280509_(x + width / 2 - accentWidth / 2, y + height + 3, x + width / 2 + accentWidth / 2, y + height + 4, accentColor);
        int accentHeight = 30;
        graphics.m_280509_(x - 4, y + height / 2 - accentHeight / 2, x - 3, y + height / 2 + accentHeight / 2, accentColor);
        graphics.m_280509_(x + width + 3, y + height / 2 - accentHeight / 2, x + width + 4, y + height / 2 + accentHeight / 2, accentColor);
        int dotSize = 2;
        graphics.m_280509_(x + width / 2 - 1, y - 5, x + width / 2 + 1, y - 5 + dotSize, accentColor);
        graphics.m_280509_(x + width / 2 - 1, y + height + 5 - dotSize, x + width / 2 + 1, y + height + 5, accentColor);
        graphics.m_280509_(x - 5, y + height / 2 - 1, x - 5 + dotSize, y + height / 2 + 1, accentColor);
        graphics.m_280509_(x + width + 5 - dotSize, y + height / 2 - 1, x + width + 5, y + height / 2 + 1, accentColor);
    }

    private void renderParticles(GuiGraphics graphics, int x, int y, int width, int height) {
        for (int i = 0; i < 15; ++i) {
            float hashX = (float)Math.sin((float)i * 12.9898f + 78.233f) * 43758.547f;
            float hashY = (float)Math.sin((float)i * 93.9898f + 12.233f) * 43758.547f;
            hashX -= (float)Math.floor(hashX);
            hashY -= (float)Math.floor(hashY);
            float speed = 0.12f + hashX * 0.08f;
            float diagonalProgress = (this.animationTime * speed + (float)i * 0.6f) % 1.8f;
            float startX = hashX * (float)width;
            float startY = hashY * (float)height;
            float offsetX = (startX + diagonalProgress * (float)width * 0.4f) % (float)width;
            float offsetY = (startY + diagonalProgress * (float)height * 0.9f) % (float)height;
            float sineWave = (float)Math.sin((double)diagonalProgress * Math.PI * 2.0 + (double)((float)i * 0.5f)) * 8.0f;
            offsetX = (offsetX + sineWave) % (float)width;
            offsetX = Math.max(0.0f, Math.min((float)(width - 3), offsetX));
            offsetY = Math.max(0.0f, Math.min((float)(height - 3), offsetY));
            float fade = diagonalProgress < 0.4f ? diagonalProgress / 0.4f : (diagonalProgress > 1.4f ? (1.8f - diagonalProgress) / 0.4f : 1.0f);
            float alphaVariation = 0.7f + hashY * 0.3f;
            int particleAlpha = (int)(fade * 100.0f * alphaVariation);
            int particleColor = particleAlpha << 24 | this.colors.particleColor & 0xFFFFFF;
            int size = hashX > 0.7f ? 3 : 2;
            graphics.m_280509_(x + (int)offsetX, y + (int)offsetY, x + (int)offsetX + size, y + (int)offsetY + size, particleColor);
            if (size != 3 || particleAlpha <= 60) continue;
            int glowAlpha = particleAlpha / 4;
            int glowColor = glowAlpha << 24 | this.colors.particleColor & 0xFFFFFF;
            graphics.m_280509_(x + (int)offsetX - 1, y + (int)offsetY - 1, x + (int)offsetX + size + 1, y + (int)offsetY + size + 1, glowColor);
        }
    }

    private void renderCornerStars(GuiGraphics graphics, Font font, int x, int y, int width, int height) {
        MutableComponent star = Component.m_237113_((String)"\u25c6");
        int offset = 6;
        float pulse = (Mth.m_14031_((float)(this.animationTime * 2.5f)) + 1.0f) / 2.0f;
        int glowAlpha = (int)(120.0f + pulse * 135.0f);
        this.renderStar(graphics, font, (Component)star, x + offset, y + offset, glowAlpha);
        this.renderStar(graphics, font, (Component)star, x + width - offset - (int)((float)font.m_92852_((FormattedText)star) * 0.9f), y + offset, glowAlpha);
        Objects.requireNonNull(font);
        this.renderStar(graphics, font, (Component)star, x + offset, y + height - offset - (int)(9.0f * 0.9f), glowAlpha);
        int n = x + width - offset - (int)((float)font.m_92852_((FormattedText)star) * 0.9f);
        Objects.requireNonNull(font);
        this.renderStar(graphics, font, (Component)star, n, y + height - offset - (int)(9.0f * 0.9f), glowAlpha);
    }

    private void renderStar(GuiGraphics graphics, Font font, Component symbol, int x, int y, int glowAlpha) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        graphics.m_280168_().m_85841_(0.9f, 0.9f, 1.0f);
        int outerColor = glowAlpha / 2 << 24 | this.colors.borderDark & 0xFFFFFF;
        int innerColor = glowAlpha << 24 | this.colors.borderAccent & 0xFFFFFF;
        graphics.m_280614_(font, symbol, -2, -2, outerColor, false);
        graphics.m_280614_(font, symbol, 2, -2, outerColor, false);
        graphics.m_280614_(font, symbol, -2, 2, outerColor, false);
        graphics.m_280614_(font, symbol, 2, 2, outerColor, false);
        graphics.m_280614_(font, symbol, -1, -1, innerColor, false);
        graphics.m_280614_(font, symbol, 1, -1, innerColor, false);
        graphics.m_280614_(font, symbol, -1, 1, innerColor, false);
        graphics.m_280614_(font, symbol, 1, 1, innerColor, false);
        graphics.m_280614_(font, symbol, 0, 0, this.colors.borderHighlight, false);
        graphics.m_280168_().m_85849_();
    }

    private int renderTitle(GuiGraphics graphics, Font font, String text, int x, int y, int maxWidth) {
        graphics.m_280168_().m_85836_();
        int scaledWidth = (int)((float)font.m_92895_(text) * 1.3f);
        int centeredX = x + (maxWidth - scaledWidth) / 2;
        graphics.m_280168_().m_252880_((float)centeredX, (float)y, 0.0f);
        graphics.m_280168_().m_85841_(1.3f, 1.3f, 1.0f);
        MutableComponent styled = Component.m_237113_((String)text).m_130940_(ChatFormatting.ITALIC);
        float pulse = (Mth.m_14031_((float)(this.animationTime * 2.0f)) + 1.0f) / 2.0f;
        int glowAlpha = (int)(40.0f + pulse * 60.0f);
        int glowColor = glowAlpha << 24 | this.colors.titleColor & 0xFFFFFF;
        for (int i = 2; i > 0; --i) {
            graphics.m_280614_(font, (Component)styled, -i, -i, glowColor, false);
            graphics.m_280614_(font, (Component)styled, i, -i, glowColor, false);
            graphics.m_280614_(font, (Component)styled, -i, i, glowColor, false);
            graphics.m_280614_(font, (Component)styled, i, i, glowColor, false);
        }
        graphics.m_280614_(font, (Component)styled, 0, 0, this.colors.titleColor, false);
        graphics.m_280168_().m_85849_();
        return 28;
    }

    private int renderSubtitle(GuiGraphics graphics, Font font, String text, int x, int y, int maxWidth) {
        graphics.m_280168_().m_85836_();
        float scale = 1.05f;
        int scaledWidth = (int)((float)font.m_92895_(text) * scale);
        int centeredX = x + (maxWidth - scaledWidth) / 2;
        int ornamentMargin = 12;
        Objects.requireNonNull(font);
        int ornamentY = y + (int)(9.0f * scale / 2.0f);
        this.renderOrnament(graphics, x, ornamentY, centeredX - ornamentMargin);
        this.renderOrnament(graphics, centeredX + scaledWidth + ornamentMargin, ornamentY, x + maxWidth);
        graphics.m_280168_().m_252880_((float)centeredX, (float)y, 0.0f);
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        MutableComponent styled = Component.m_237113_((String)text).m_130940_(ChatFormatting.ITALIC);
        float pulse = (Mth.m_14031_((float)(this.animationTime * 2.5f)) + 1.0f) / 2.0f;
        int glowAlpha = (int)(30.0f + pulse * 50.0f);
        int glowColor = glowAlpha << 24 | this.colors.subtitleColor & 0xFFFFFF;
        graphics.m_280614_(font, (Component)styled, -1, -1, glowColor, false);
        graphics.m_280614_(font, (Component)styled, 1, -1, glowColor, false);
        graphics.m_280614_(font, (Component)styled, -1, 1, glowColor, false);
        graphics.m_280614_(font, (Component)styled, 1, 1, glowColor, false);
        graphics.m_280614_(font, (Component)styled, 0, 0, this.colors.subtitleColor, false);
        graphics.m_280168_().m_85849_();
        return 20;
    }

    private void renderOrnament(GuiGraphics graphics, int startX, int y, int endX) {
        int i;
        int length = Math.abs(endX - startX);
        float flow = this.animationTime * 1.5f;
        for (i = 0; i < length; i += 2) {
            float brightness = (Mth.m_14031_((float)(flow + (float)i * 0.15f)) + 1.0f) / 2.0f;
            int alpha = (int)(80.0f + brightness * 120.0f);
            int color = alpha << 24 | this.colors.borderAccent & 0xFFFFFF;
            graphics.m_280509_(startX + i, y, startX + i + 1, y + 1, color);
        }
        for (i = 0; i < 3; ++i) {
            float position = (float)(i + 1) / 4.0f;
            int dotX = startX + (int)((float)length * position);
            float dotPulse = (Mth.m_14031_((float)(this.animationTime * 2.0f + (float)i * 0.5f)) + 1.0f) / 2.0f;
            int dotAlpha = (int)(150.0f + dotPulse * 105.0f);
            int dotColor = dotAlpha << 24 | this.colors.particleColor & 0xFFFFFF;
            graphics.m_280509_(dotX, y - 1, dotX + 1, y, dotColor);
            graphics.m_280509_(dotX - 1, y, dotX + 2, y + 1, dotColor);
            graphics.m_280509_(dotX, y + 1, dotX + 1, y + 2, dotColor);
        }
    }

    private void renderPageDecorator(GuiGraphics graphics, Font font, int x, int y, int width) {
        float pulse = (Mth.m_14031_((float)(this.animationTime * 2.0f)) + 1.0f) / 2.0f;
        int lineAlpha = (int)(120.0f + pulse * 135.0f);
        int lineColor = lineAlpha << 24 | this.colors.borderAccent & 0xFFFFFF;
        int centerX = x + width / 2;
        int lineWidth = 80;
        graphics.m_280509_(centerX - lineWidth / 2, y, centerX + lineWidth / 2, y + 1, lineColor);
        MutableComponent ornament = Component.m_237113_((String)"\u2756");
        int ornamentWidth = font.m_92852_((FormattedText)ornament);
        graphics.m_280614_(font, (Component)ornament, centerX - ornamentWidth / 2, y - 4, this.colors.borderHighlight, false);
    }

    private void renderPageIndicators(GuiGraphics graphics, Font font, int x, int y, int width, int page, int totalPages) {
        if (page == 0) {
            return;
        }
        int totalWidth = totalPages * 6 + (totalPages - 1) * 10;
        int startX = x + (width - totalWidth) / 2;
        float pulse = (Mth.m_14031_((float)(this.animationTime * 3.0f)) + 1.0f) / 2.0f;
        for (int i = 1; i <= totalPages; ++i) {
            MutableComponent dot;
            int dotX = startX + (i - 1) * 16;
            int dotY = y + 1;
            if (i == page) {
                dot = Component.m_237113_((String)"\u25cf");
                int glowAlpha = (int)(220.0f + pulse * 35.0f);
                int activeColor = glowAlpha << 24 | this.colors.borderHighlight & 0xFFFFFF;
                int glowColor = 0x50000000 | this.colors.particleColor & 0xFFFFFF;
                graphics.m_280614_(font, (Component)dot, dotX - 2, dotY - 2, glowColor, false);
                graphics.m_280614_(font, (Component)dot, dotX + 2, dotY - 2, glowColor, false);
                graphics.m_280614_(font, (Component)dot, dotX - 2, dotY + 2, glowColor, false);
                graphics.m_280614_(font, (Component)dot, dotX + 2, dotY + 2, glowColor, false);
                graphics.m_280614_(font, (Component)dot, dotX, dotY, activeColor, false);
                continue;
            }
            dot = Component.m_237113_((String)"\u25cb");
            int inactiveColor = 0xB4000000 | this.colors.borderBase & 0xFFFFFF;
            graphics.m_280614_(font, (Component)dot, dotX, dotY, inactiveColor, false);
        }
        int arrowAlpha = (int)(120.0f + pulse * 135.0f);
        int arrowColor = arrowAlpha << 24 | this.colors.subtitleColor & 0xFFFFFF;
        if (page > 1) {
            graphics.m_280614_(font, (Component)Component.m_237113_((String)"\u25c4"), startX - 20, y, arrowColor, false);
        }
        if (page < totalPages) {
            graphics.m_280614_(font, (Component)Component.m_237113_((String)"\u25ba"), startX + totalWidth + 12, y, arrowColor, false);
        }
    }

    private int calculateContentHeight(List<WrappedParagraph> paragraphs, int totalPages, int displayPage) {
        int height = displayPage == 1 ? 48 : 35;
        for (WrappedParagraph para : paragraphs) {
            height += para.lines.size() * 11 + 10;
        }
        if (totalPages > 1) {
            height += 20;
        }
        return height;
    }

    private int calculateCreditsHeight(AbstractLoreItem.LoreCredits credits) {
        int height = 50;
        if (!credits.getDocumentName().isEmpty()) {
            height += 15;
        }
        if (!credits.getLoreAuthor().isEmpty()) {
            height += 15;
        }
        if (!credits.getOriginalAuthor().isEmpty()) {
            height += 15;
        }
        if (!credits.getCredits().isEmpty()) {
            height += 15;
        }
        if (!credits.getVolume().isEmpty()) {
            height += 15;
        }
        if (!credits.getWrittenDate().isEmpty()) {
            height += 15;
        }
        if (!credits.getLastUpdated().isEmpty()) {
            height += 15;
        }
        height += 15;
        return height += 20;
    }

    private void renderCreditsPage(GuiGraphics graphics, Font font, AbstractLoreItem.LoreCredits credits, int x, int y, int maxWidth) {
        int centerX = x + maxWidth / 2;
        MutableComponent creditsTitle = Component.m_237113_((String)"\u25c6 ").m_7220_((Component)Component.m_237115_((String)"lore_item.traveloptics.credits.title")).m_130946_(" \u25c6");
        int titleWidth = font.m_92852_((FormattedText)creditsTitle);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)(centerX - titleWidth / 2), (float)(y += 15), 0.0f);
        graphics.m_280168_().m_85841_(1.15f, 1.15f, 1.0f);
        float pulse = (Mth.m_14031_((float)(this.animationTime * 2.0f)) + 1.0f) / 2.0f;
        int glowAlpha = (int)(50.0f + pulse * 70.0f);
        int glowColor = glowAlpha << 24 | this.colors.titleColor & 0xFFFFFF;
        graphics.m_280614_(font, (Component)creditsTitle, -1, -1, glowColor, false);
        graphics.m_280614_(font, (Component)creditsTitle, 1, -1, glowColor, false);
        graphics.m_280614_(font, (Component)creditsTitle, -1, 1, glowColor, false);
        graphics.m_280614_(font, (Component)creditsTitle, 1, 1, glowColor, false);
        graphics.m_280614_(font, (Component)creditsTitle, 0, 0, this.colors.titleColor, false);
        graphics.m_280168_().m_85849_();
        y += 25;
        if (!credits.getDocumentName().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.traveloptics.credits.document", credits.getDocumentName(), x, y, maxWidth);
        }
        if (!credits.getLoreAuthor().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.traveloptics.credits.lore_author", credits.getLoreAuthor(), x, y, maxWidth);
        }
        if (!credits.getOriginalAuthor().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.traveloptics.credits.original_author", credits.getOriginalAuthor(), x, y, maxWidth);
        }
        if (!credits.getCredits().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.traveloptics.credits.credits", credits.getCredits(), x, y, maxWidth);
        }
        if (!credits.getVolume().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.traveloptics.credits.volume", credits.getVolume(), x, y, maxWidth);
        }
        if (!credits.getWrittenDate().isEmpty()) {
            y += this.renderCreditsField(graphics, font, "lore_item.traveloptics.credits.written_date", credits.getWrittenDate(), x, y, maxWidth);
        }
        if (!credits.getLastUpdated().isEmpty()) {
            this.renderCreditsField(graphics, font, "lore_item.traveloptics.credits.last_updated", credits.getLastUpdated(), x, y, maxWidth);
        }
    }

    private int renderCreditsField(GuiGraphics graphics, Font font, String labelKey, String value, int x, int y, int maxWidth) {
        MutableComponent labelComp = Component.m_237115_((String)labelKey).m_130940_(ChatFormatting.ITALIC);
        MutableComponent valueComp = Component.m_237113_((String)value);
        int labelWidth = font.m_92852_((FormattedText)labelComp);
        int valueWidth = font.m_92852_((FormattedText)valueComp);
        int totalWidth = labelWidth + 10 + valueWidth;
        int startX = x + (maxWidth - totalWidth) / 2;
        MutableComponent dot = Component.m_237113_((String)"\u2022");
        graphics.m_280614_(font, (Component)dot, startX - 8, y, this.colors.borderAccent, false);
        graphics.m_280614_(font, (Component)labelComp, startX, y, this.colors.subtitleColor, false);
        graphics.m_280614_(font, (Component)valueComp, startX + labelWidth + 10, y, this.colors.textColor, false);
        return 15;
    }

    private int renderParagraph(GuiGraphics graphics, Font font, WrappedParagraph paragraph, int x, int y, boolean stylizeFirst, int firstWordMargin) {
        int currentY = y;
        for (int lineIdx = 0; lineIdx < paragraph.lines.size(); ++lineIdx) {
            String line = paragraph.lines.get(lineIdx);
            if (stylizeFirst && lineIdx == 0 && !line.isEmpty()) {
                int spaceIndex = line.indexOf(32);
                String firstWord = spaceIndex > 0 ? line.substring(0, spaceIndex) : line;
                String restOfLine = spaceIndex > 0 ? line.substring(spaceIndex + 1) : "";
                MutableComponent firstWordComp = Component.m_237113_((String)firstWord).m_130940_(ChatFormatting.BOLD);
                float dropCapScale = 1.3f;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)x, (float)(currentY - 2), 0.0f);
                graphics.m_280168_().m_85841_(dropCapScale, dropCapScale, 1.0f);
                for (int i = 2; i >= 0; --i) {
                    int glowAlpha = 60 - i * 20;
                    int glowColor = glowAlpha << 24 | this.colors.particleColor & 0xFFFFFF;
                    graphics.m_280614_(font, (Component)firstWordComp, -i, -i, glowColor, false);
                    graphics.m_280614_(font, (Component)firstWordComp, i, -i, glowColor, false);
                    graphics.m_280614_(font, (Component)firstWordComp, -i, i, glowColor, false);
                    graphics.m_280614_(font, (Component)firstWordComp, i, i, glowColor, false);
                }
                graphics.m_280614_(font, (Component)firstWordComp, 0, 0, this.colors.firstWordColor, true);
                graphics.m_280168_().m_85849_();
                int firstWordWidth = (int)((float)font.m_92895_(firstWord) * dropCapScale);
                MutableComponent restComp = Component.m_237113_((String)restOfLine);
                graphics.m_280614_(font, (Component)restComp, x + firstWordWidth + firstWordMargin, currentY + 1, this.colors.textColor, false);
                currentY += 14;
                continue;
            }
            graphics.m_280614_(font, (Component)Component.m_237113_((String)line), x, currentY, this.colors.textColor, false);
            currentY += 11;
        }
        return currentY - y;
    }

    private WrappedParagraph wrapText(String text, Font font, int maxWidth) {
        String[] words = text.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.isEmpty() ? word : String.valueOf(currentLine) + " " + word;
            if (font.m_92895_(testLine) <= maxWidth) {
                if (!currentLine.isEmpty()) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (!currentLine.isEmpty()) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine.toString());
        }
        return new WrappedParagraph(lines);
    }

    private void fillGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_193479_(colorA).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_193479_(colorA).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_193479_(colorB).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_193479_(colorB).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
    }

    private void fillGradientHorizontal(GuiGraphics graphics, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_193479_(colorB).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_193479_(colorA).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_193479_(colorA).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_193479_(colorB).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
    }

    private static class WrappedParagraph {
        final List<String> lines;

        WrappedParagraph(List<String> lines) {
            this.lines = lines;
        }
    }
}

