/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api.boss_screen;

import com.gametechbc.traveloptics.api.utils.GUIColorThemeBuilder;
import com.gametechbc.traveloptics.init.TravelopticsGUIColorThemes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BossScreenData {
    private final Component bossName;
    private final Component bossTitle;
    private final ResourceLocation bossImageLocation;
    private final int bossImageWidth;
    private final int bossImageHeight;
    private final float bossImageScale;
    private final int bossImageOffsetX;
    private final int bossImageOffsetY;
    private final Component loreText;
    private final List<Component> battleSuggestions;
    private final GUIColorThemeBuilder colorTheme;
    private final String bossRegistryKey;
    private final List<AdvancedInfo> advancedInfoSections;
    private final List<AdvancedInfo> spoilerInfoSections;
    private final List<RequiredItem> requiredItems;
    private final List<RewardItem> rewards;
    private final List<DifficultyOption> difficultyOptions;

    private BossScreenData(Builder builder) {
        this.bossName = builder.bossName;
        this.bossTitle = builder.bossTitle;
        this.bossImageLocation = builder.bossImageLocation;
        this.bossImageWidth = builder.bossImageWidth;
        this.bossImageHeight = builder.bossImageHeight;
        this.bossImageScale = builder.bossImageScale;
        this.bossImageOffsetX = builder.bossImageOffsetX;
        this.bossImageOffsetY = builder.bossImageOffsetY;
        this.loreText = builder.loreText;
        this.battleSuggestions = builder.battleSuggestions;
        this.colorTheme = builder.colorTheme;
        this.bossRegistryKey = builder.bossRegistryKey;
        this.advancedInfoSections = builder.advancedInfoSections;
        this.spoilerInfoSections = builder.spoilerInfoSections;
        this.requiredItems = new ArrayList<RequiredItem>(builder.requiredItems);
        this.rewards = new ArrayList<RewardItem>(builder.rewards);
        this.difficultyOptions = new ArrayList<DifficultyOption>(builder.difficultyOptions);
    }

    public Component getBossName() {
        return this.bossName;
    }

    public Component getBossTitle() {
        return this.bossTitle;
    }

    public ResourceLocation getBossImageLocation() {
        return this.bossImageLocation;
    }

    public int getBossImageWidth() {
        return this.bossImageWidth;
    }

    public int getBossImageHeight() {
        return this.bossImageHeight;
    }

    public float getBossImageScale() {
        return this.bossImageScale;
    }

    public int getBossImageOffsetX() {
        return this.bossImageOffsetX;
    }

    public int getBossImageOffsetY() {
        return this.bossImageOffsetY;
    }

    public Component getLoreText() {
        return this.loreText;
    }

    public List<Component> getBattleSuggestions() {
        return this.battleSuggestions;
    }

    public GUIColorThemeBuilder getColorTheme() {
        return this.colorTheme;
    }

    public String getBossRegistryKey() {
        return this.bossRegistryKey;
    }

    public List<AdvancedInfo> getAdvancedInfoSections() {
        return this.advancedInfoSections;
    }

    public List<AdvancedInfo> getSpoilerInfoSections() {
        return this.spoilerInfoSections;
    }

    public List<RequiredItem> getRequiredItems() {
        return this.requiredItems;
    }

    public List<RewardItem> getRewards() {
        return this.rewards;
    }

    public List<DifficultyOption> getDifficultyOptions() {
        return this.difficultyOptions;
    }

    public boolean hasDifficulties() {
        return !this.difficultyOptions.isEmpty();
    }

    public static Builder builder(String registryKey) {
        return new Builder(registryKey);
    }

    public static class Builder {
        private final String bossRegistryKey;
        private Component bossName = Component.m_237115_((String)"gui.traveloptics.boss_screen.unknown.name");
        private Component bossTitle = Component.m_237115_((String)"gui.traveloptics.boss_screen.unknown.title");
        private ResourceLocation bossImageLocation = null;
        private int bossImageWidth = -1;
        private int bossImageHeight = -1;
        private float bossImageScale = -1.0f;
        private int bossImageOffsetX = 0;
        private int bossImageOffsetY = 0;
        private Component loreText = Component.m_237115_((String)"gui.traveloptics.boss_screen.unknown.lore");
        private List<Component> battleSuggestions = List.of();
        private GUIColorThemeBuilder colorTheme;
        private List<AdvancedInfo> advancedInfoSections = new ArrayList<AdvancedInfo>();
        private List<AdvancedInfo> spoilerInfoSections = new ArrayList<AdvancedInfo>();
        private final List<RequiredItem> requiredItems = new ArrayList<RequiredItem>();
        private final List<RewardItem> rewards = new ArrayList<RewardItem>();
        private final List<DifficultyOption> difficultyOptions = new ArrayList<DifficultyOption>();

        private Builder(String registryKey) {
            this.bossRegistryKey = registryKey;
            this.colorTheme = TravelopticsGUIColorThemes.ENDER;
        }

        public Builder bossName(Component name) {
            this.bossName = name;
            return this;
        }

        public Builder bossTitle(Component title) {
            this.bossTitle = title;
            return this;
        }

        public Builder bossImage(ResourceLocation location, int width, int height, float scale, int offsetX, int offsetY) {
            this.bossImageLocation = location;
            this.bossImageWidth = width;
            this.bossImageHeight = height;
            this.bossImageScale = scale;
            this.bossImageOffsetX = offsetX;
            this.bossImageOffsetY = offsetY;
            return this;
        }

        public Builder lore(Component lore) {
            this.loreText = lore;
            return this;
        }

        public Builder suggestions(List<Component> suggestions) {
            this.battleSuggestions = suggestions;
            return this;
        }

        public Builder suggestions(Component ... suggestions) {
            this.battleSuggestions = List.of(suggestions);
            return this;
        }

        public Builder colorTheme(GUIColorThemeBuilder theme) {
            this.colorTheme = theme;
            return this;
        }

        public Builder addAdvancedInfo(Component title, Component description) {
            this.advancedInfoSections.add(new AdvancedInfo(title, description));
            return this;
        }

        public Builder addSpoilerAdvancedInfo(Component title, Component description) {
            this.spoilerInfoSections.add(new AdvancedInfo(title, description));
            return this;
        }

        public Builder advancedInfo(List<AdvancedInfo> sections) {
            this.advancedInfoSections = new ArrayList<AdvancedInfo>(sections);
            return this;
        }

        public BossScreenData build() {
            if (this.bossImageLocation != null && (this.bossImageWidth <= 0 || this.bossImageHeight <= 0 || this.bossImageScale <= 0.0f)) {
                throw new IllegalStateException("Boss image requires width, height, and scale to be set via bossImage() method");
            }
            return new BossScreenData(this);
        }

        public Builder requiredItem(ItemStack item, int quantity) {
            this.requiredItems.add(new RequiredItem(item, quantity));
            return this;
        }

        public Builder requiredItem(ItemStack item) {
            return this.requiredItem(item, 1);
        }

        public Builder requiredItems(List<RequiredItem> items) {
            this.requiredItems.addAll(items);
            return this;
        }

        public Builder reward(ItemStack item, RewardRarity rarity) {
            this.rewards.add(new RewardItem(item, rarity));
            return this;
        }

        public Builder difficultyOption(Component name, int difficultyIndex, List<Component> bonuses) {
            this.difficultyOptions.add(new DifficultyOption(name, difficultyIndex, bonuses));
            return this;
        }

        public Builder difficultyOptions(List<DifficultyOption> options) {
            this.difficultyOptions.addAll(options);
            return this;
        }
    }

    public static class DifficultyOption {
        private final Component name;
        private final int difficultyIndex;
        private final List<Component> bonuses;

        public DifficultyOption(Component name, int difficultyIndex, List<Component> bonuses) {
            this.name = name;
            this.difficultyIndex = difficultyIndex;
            this.bonuses = new ArrayList<Component>(bonuses);
        }

        public Component getName() {
            return this.name;
        }

        public int getDifficultyIndex() {
            return this.difficultyIndex;
        }

        public List<Component> getBonuses() {
            return this.bonuses;
        }
    }

    public static enum RewardRarity {
        NORMAL(-1996488705, 0x44FFFFFF),
        UNCOMMON(-11141291, 0x6633AA33),
        RARE(-16733441, 1711311069),
        EPIC(-4504321, 1720202188),
        LEGENDARY(-2838729, 1723833136);

        private final int glowColor;
        private final int frameColor;

        private RewardRarity(int glowColor, int frameColor) {
            this.glowColor = glowColor;
            this.frameColor = frameColor;
        }

        public int getGlowColor() {
            return this.glowColor;
        }

        public int getFrameColor() {
            return this.frameColor;
        }
    }

    public static class RequiredItem {
        private final ItemStack item;
        private final int quantity;

        public RequiredItem(ItemStack item, int quantity) {
            this.item = item;
            this.quantity = quantity;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public int getQuantity() {
            return this.quantity;
        }
    }

    public static class AdvancedInfo {
        private final Component title;
        private final Component description;

        public AdvancedInfo(Component title, Component description) {
            this.title = title;
            this.description = description;
        }

        public Component getTitle() {
            return this.title;
        }

        public Component getDescription() {
            return this.description;
        }
    }

    public static class RewardItem {
        private final ItemStack item;
        private final RewardRarity rarity;

        public RewardItem(ItemStack item, RewardRarity rarity) {
            this.item = item;
            this.rarity = rarity;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public RewardRarity getRarity() {
            return this.rarity;
        }
    }
}

