/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.functions;

import java.util.Arrays;

public class IntFlatMap<V> {
    private int[] keys;
    private V[] values;
    private int size = 0;

    public IntFlatMap(int capacity) {
        this.keys = new int[capacity];
        this.values = new Object[capacity];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public V get(int key) {
        int index = this.findIndex(key);
        return index >= 0 ? (V)this.values[index] : null;
    }

    public void put(int key, V value) {
        if (this.size >= this.keys.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.keys[this.size] = key;
        this.values[this.size] = value;
        ++this.size;
    }

    public V remove(int key) {
        int index = this.findIndex(key);
        if (index < 0) {
            return null;
        }
        V oldValue = this.values[index];
        this.shift(index);
        return oldValue;
    }

    private int findIndex(int key) {
        return Arrays.binarySearch(this.keys, key);
    }

    private void shift(int index) {
        System.arraycopy(this.keys, index + 1, this.keys, index, this.size - index - 1);
        System.arraycopy(this.values, index + 1, this.values, index, this.size - index - 1);
        this.values[this.size - 1] = null;
        --this.size;
    }

    public void resize(int newCapacity) {
        this.keys = Arrays.copyOf(this.keys, newCapacity);
        this.values = Arrays.copyOf(this.values, newCapacity);
    }

    public void sort() {
        if (this.size != this.keys.length) {
            this.resize(this.size);
        }
        this.quickSort(0, this.size - 1);
    }

    private void quickSort(int low, int high) {
        if (low < high) {
            int pi = this.partition(low, high);
            this.quickSort(low, pi - 1);
            this.quickSort(pi + 1, high);
        }
    }

    private int partition(int low, int high) {
        int pivot = this.keys[high];
        int i = low - 1;
        for (int j = low; j < high; ++j) {
            if (this.keys[j] >= pivot) continue;
            this.swap(++i, j);
        }
        this.swap(i + 1, high);
        return i + 1;
    }

    private void swap(int i, int j) {
        int tempintey = this.keys[i];
        this.keys[i] = this.keys[j];
        this.keys[j] = tempintey;
        V tempValue = this.values[i];
        this.values[i] = this.values[j];
        this.values[j] = tempValue;
    }

    public void clear() {
        Arrays.fill(this.keys, 0, this.size, 0);
        Arrays.fill(this.values, 0, this.size, null);
        this.size = 0;
    }
}

