/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.functions.Chunk;

import java.lang.reflect.Field;
import me.jellysquid.mods.sodium.client.render.viewport.frustum.Frustum;
import org.joml.FrustumIntersection;
import org.joml.Vector4f;

public class FastSimpleFrustum
implements Frustum {
    public static final float CHUNK_SECTION_RADIUS = 8.0f;
    public static final float CHUNK_SECTION_SIZE = 9.125f;
    private float nxX;
    private float nxY;
    private float nxZ;
    private float negNxW;
    private float pxX;
    private float pxY;
    private float pxZ;
    private float negPxW;
    private float nyX;
    private float nyY;
    private float nyZ;
    private float negNyW;
    private float pyX;
    private float pyY;
    private float pyZ;
    private float negPyW;
    private float nzX;
    private float nzY;
    private float nzZ;
    private float negNzW;

    public FastSimpleFrustum(FrustumIntersection frustumIntersection) {
        Vector4f[] planes = FastSimpleFrustum.getFrustumPlanes(frustumIntersection);
        this.nxX = planes[0].x;
        this.nxY = planes[0].y;
        this.nxZ = planes[0].z;
        this.pxX = planes[1].x;
        this.pxY = planes[1].y;
        this.pxZ = planes[1].z;
        this.nyX = planes[2].x;
        this.nyY = planes[2].y;
        this.nyZ = planes[2].z;
        this.pyX = planes[3].x;
        this.pyY = planes[3].y;
        this.pyZ = planes[3].z;
        this.nzX = planes[4].x;
        this.nzY = planes[4].y;
        this.nzZ = planes[4].z;
        float size = 9.125f;
        this.negNxW = 2.0f * -(planes[0].w + this.nxX * (this.nxX < 0.0f ? -9.125f : 9.125f) + this.nxY * (this.nxY < 0.0f ? -9.125f : 9.125f) + this.nxZ * (this.nxZ < 0.0f ? -9.125f : 9.125f));
        this.negPxW = 2.0f * -(planes[1].w + this.pxX * (this.pxX < 0.0f ? -9.125f : 9.125f) + this.pxY * (this.pxY < 0.0f ? -9.125f : 9.125f) + this.pxZ * (this.pxZ < 0.0f ? -9.125f : 9.125f));
        this.negNyW = 2.0f * -(planes[2].w + this.nyX * (this.nyX < 0.0f ? -9.125f : 9.125f) + this.nyY * (this.nyY < 0.0f ? -9.125f : 9.125f) + this.nyZ * (this.nyZ < 0.0f ? -9.125f : 9.125f));
        this.negPyW = 2.0f * -(planes[3].w + this.pyX * (this.pyX < 0.0f ? -9.125f : 9.125f) + this.pyY * (this.pyY < 0.0f ? -9.125f : 9.125f) + this.pyZ * (this.pyZ < 0.0f ? -9.125f : 9.125f));
        this.negNzW = 2.0f * -(planes[4].w + this.nzX * (this.nzX < 0.0f ? -9.125f : 9.125f) + this.nzY * (this.nzY < 0.0f ? -9.125f : 9.125f) + this.nzZ * (this.nzZ < 0.0f ? -9.125f : 9.125f));
    }

    private static Vector4f[] getFrustumPlanes(Object frustumIntersection) {
        Vector4f[] planes;
        try {
            Field planesField = FrustumIntersection.class.getDeclaredField("planes");
            planesField.setAccessible(true);
            planes = (Vector4f[])planesField.get(frustumIntersection);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to access planes field in FrustumIntersection", e);
        }
        return planes;
    }

    public boolean testCubeQuick(float wx, float wy, float wz) {
        return this.nxX * wx + this.nxY * wy + this.nxZ * wz >= this.negNxW && this.pxX * wx + this.pxY * wy + this.pxZ * wz >= this.negPxW && this.nyX * wx + this.nyY * wy + this.nyZ * wz >= this.negNyW && this.pyX * wx + this.pyY * wy + this.pyZ * wz >= this.negPyW && this.nzX * wx + this.nzY * wy + this.nzZ * wz >= this.negNzW;
    }

    public boolean testAab(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return this.testCubeQuick(minX + maxX, minY + maxY, minZ + maxZ);
    }
}

