/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.Chorusling.ChoruslingEntity;
import net.miauczel.legendary_monsters.entity.animations.ChoruslingAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ChoruslingModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;

    public ChoruslingModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.head = root.m_171324_("root").m_171324_("body").m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)-16.0f, (float)-3.5f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -14.0f, -3.5f, 12.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)3.5f));
        PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-8.0f, 0.001f, 0.0f, 8.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-6.001f, (float)4.5f, (float)1.5708f, (float)0.5236f, (float)1.5708f));
        PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-10.0f, 0.001f, -1.0f, 10.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-11.0f, (float)4.5f, (float)1.5708f, (float)0.5236f, (float)1.5708f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(48, 12).m_171488_(-4.0f, -8.0f, -7.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)-0.5f));
        PartDefinition rightarm = body.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(24, 36).m_171488_(-3.25f, -1.5f, -3.0f, 6.0f, 31.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(60, 28).m_171488_(-8.25f, -1.5f, 0.0f, 5.0f, 31.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-8.75f, (float)-12.5f, (float)-0.5f));
        PartDefinition leftarm = body.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-2.75f, -1.5f, -3.0f, 6.0f, 31.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(60, 59).m_171488_(3.25f, -1.5f, 0.0f, 5.0f, 31.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.75f, (float)-12.5f, (float)-0.5f));
        PartDefinition leftleg = root.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(48, 28).m_171488_(-1.5f, 0.5f, -1.5f, 3.0f, 27.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)12.5f, (float)4.0f));
        PartDefinition rightleg = root.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(48, 58).m_171488_(-1.5f, 0.5f, -1.5f, 3.0f, 27.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)12.5f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation((ChoruslingEntity)((Object)entity), netHeadYaw, headPitch, ageInTicks);
        this.m_267799_(ChoruslingAnimations.WALK2, limbSwing, limbSwingAmount, 1.5f, 2.5f);
        this.m_233385_(((ChoruslingEntity)((Object)entity)).idleAnimationState, ChoruslingAnimations.IDLE, ageInTicks, 1.0f);
        this.m_233385_(((ChoruslingEntity)((Object)entity)).attackAnimationState, ChoruslingAnimations.ATTACK, ageInTicks, 1.0f);
        this.m_233385_(((ChoruslingEntity)((Object)entity)).DeathAnimationState, ChoruslingAnimations.DEATH, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(ChoruslingEntity pEntity, float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)25.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

