/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Old;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.Shulker_MimicEntity;
import net.miauczel.legendary_monsters.entity.ai.Shulker_MimicAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.item.ModItems;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeEntity;
import org.jetbrains.annotations.Nullable;

public class OldShulkerMimic
extends Monster
implements IForgeEntity {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Shulker_MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int cooldown = 0;
    private static final int COOLDOWN_DURATION = 35;
    private static final float MAX_ROTATION = 0.0f;
    private static final float ROTATION_SPEED = 0.2f;
    private static final double HITBOX_RADIUS = 3.0;
    private static final double HITBOX_HEIGHT = 2.0;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    private float prevYaw;
    private boolean hasPlayedCrackSound = false;
    private boolean hasPlayedCrackSound1 = false;
    private boolean hasPlayedCrackSound2 = false;
    public int dragonDeathTime;
    public final AnimationState DeathAnimationState = new AnimationState();
    public int DeathAnimationTimeout = 60;

    public OldShulkerMimic(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 20;
        this.m_21557_(false);
        this.m_21530_();
        this.m_21530_();
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    public void performAreaAttack() {
        double attackRadius = 2.0;
        double attackHeight = 2.0;
        AABB attackBox = new AABB(this.m_20185_() - attackRadius, this.m_20186_(), this.m_20189_() - attackRadius, this.m_20185_() + attackRadius, this.m_20186_() + attackHeight, this.m_20189_() + attackRadius);
        List entities = this.m_9236_().m_45933_((Entity)this, attackBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this || entity == this.m_5448_() || this.m_5448_() == null || entity instanceof CameraShakeEntity) continue;
            if (Math.random() < 0.75) {
                Shulker_MimicEntity.Crackiness crackiness = this.getCrackiness();
                if (crackiness == Shulker_MimicEntity.Crackiness.MEDIUM) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.GRAVITY_PULL.get(), 60, 4));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 40, 3));
                } else {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 40, 2));
                }
                if (crackiness == Shulker_MimicEntity.Crackiness.HIGH) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.GRAVITY_PULL.get(), 60, 5));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 20, 10));
                } else {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 40, 2));
                }
            }
            this.m_7327_((Entity)livingEntity);
        }
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public void m_8119_() {
        SoundEvent cracksound;
        Shulker_MimicEntity.Crackiness crackiness;
        super.m_8119_();
        if (this.DeathAnimationState.m_216984_()) {
            --this.DeathAnimationTimeout;
            if (this.DeathAnimationTimeout <= 0) {
                this.DeathAnimationState.m_216973_();
            }
        }
        if ((crackiness = this.getCrackiness()) == Shulker_MimicEntity.Crackiness.LOW && !this.hasPlayedCrackSound2) {
            cracksound = SoundEvents.f_12414_;
            this.hasPlayedCrackSound2 = true;
            this.m_9236_().m_5594_(null, this.m_20183_(), cracksound, SoundSource.NEUTRAL, 2.0f, 1.0f);
        }
        if (crackiness == Shulker_MimicEntity.Crackiness.MEDIUM && !this.hasPlayedCrackSound1) {
            SoundEvent cracksound2 = SoundEvents.f_12414_;
            this.hasPlayedCrackSound1 = true;
            this.m_9236_().m_5594_(null, this.m_20183_(), cracksound2, SoundSource.NEUTRAL, 2.0f, 1.0f);
        }
        if (crackiness == Shulker_MimicEntity.Crackiness.HIGH && !this.hasPlayedCrackSound) {
            cracksound = SoundEvents.f_12414_;
            this.hasPlayedCrackSound = true;
            this.m_9236_().m_5594_(null, this.m_20183_(), cracksound, SoundSource.NEUTRAL, 2.0f, 1.0f);
        }
        this.updateAttributes();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public Shulker_MimicEntity.Crackiness getCrackiness() {
        return Shulker_MimicEntity.Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    private void setupAnimationStates() {
        if (this.DeathAnimationTimeout >= 60) {
            if (this.dragonDeathTime > 0 && !this.DeathAnimationState.m_216984_()) {
                this.DeathAnimationState.m_216977_(this.f_19797_);
                --this.DeathAnimationTimeout;
                this.stopAllOtherAnimations();
            }
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
                this.idleAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.idleAnimationTimeout;
            }
            if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
                this.attackAnimationTimeout = 23;
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.attackAnimationTimeout;
            }
            if (!this.isAttacking() && this.attackAnimationTimeout <= 0) {
                this.attackAnimationState.m_216973_();
            }
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new Shulker_MimicAttackGoal((PathfinderMob)this, 3.0, true));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_8107_() {
        LivingEntity target;
        super.m_8107_();
        if (this.f_19862_ && this.m_5830_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.1, 0.0, 0.1));
        }
        if ((target = this.m_5448_()) != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 12.0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    public void attackTargets(Entity entity1) {
        DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
        double damage = 13.0 * (Double)ModConfig.MOB_CONFIG.ShulkerMimicDamageMutliplier.get();
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity1;
            if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                livingEntity.m_6469_(damageSource, (float)(damage - 6.0));
            } else if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                livingEntity.m_6469_(damageSource, (float)damage);
            } else if (this.m_9236_().m_46791_() == Difficulty.EASY) {
                livingEntity.m_6469_(damageSource, (float)(damage + 8.0));
            }
        }
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.ShulkerMimicHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.ShulkerMimicDamageMutliplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 180.0;
        double baseAttackDamage = 12.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12407_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12415_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12413_;
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (((Boolean)ModConfig.MOB_CONFIG.Shulkerprojectile.get()).booleanValue() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268434_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268546_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
    }

    protected void m_6153_() {
        ++this.dragonDeathTime;
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        if (this.m_9236_() instanceof ServerLevel && this.dragonDeathTime > 1 && !this.m_20067_()) {
            this.m_21557_(true);
        }
        if (this.dragonDeathTime == 30) {
            Vec3 vec3 = this.m_20182_();
        }
        if (this.dragonDeathTime == 60 && this.m_9236_() instanceof ServerLevel) {
            ItemStack diamond = new ItemStack((ItemLike)ModItems.LARGE_SHULKER_SHELL.get(), 1);
            ItemStack emerald = new ItemStack((ItemLike)Items.f_42748_, 5);
            ItemStack ruby = new ItemStack((ItemLike)Items.f_42748_, 3);
            if (Math.random() > 0.5) {
                // empty if block
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    private void stopAllOtherAnimations() {
        this.attackAnimationState.m_216973_();
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        public final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness shulkermimic$crackiness : BY_DAMAGE) {
                if (!(pFraction < shulkermimic$crackiness.fraction)) continue;
                return shulkermimic$crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

