/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.AncientStronghold;

import java.util.List;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.AncientStronghold.SpikebugEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.extensions.IForgeEntity;
import org.jetbrains.annotations.Nullable;

public class AmbusherEntity
extends IAnimatedMonster
implements IForgeEntity {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(AmbusherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int dragonDeathTime;
    public final AnimationState DeathAnimationState = new AnimationState();
    public int DeathAnimationTimeout = 20;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState toungueAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public AmbusherEntity(EntityType<? extends IAnimatedMonster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 2;
        this.m_21557_(false);
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.UpdateWithAttack();
        this.updateAttributes();
        if (this.m_9236_().m_5776_()) {
            // empty if block
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true, false));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 2, 0, 15, 48, 3.5f){});
    }

    public void m_8107_() {
        LivingEntity target;
        super.m_8107_();
        if (this.f_19862_ && this.m_5830_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.1, 0.0, 0.1));
        }
        if ((target = this.m_5448_()) != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 14.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 8.0);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.ANCIENT_GUARDIAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.CHORUSLING_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    private void AreaAttack(float range, float height, float arc, float damage) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            boolean flag;
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if ((entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f || entityRelativeAngle <= -360.0f + arc / 2.0f) && !this.m_7307_((Entity)entityHit) && entityHit != this && !(entityHit instanceof AmbusherEntity) && entityHit == this.m_5448_() && !(flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.AmbusherDamageMultiplier.get())))) continue;
        }
    }

    public void UpdateWithAttack() {
        if (this.getAttackState() == 2) {
            if (this.attackTicks == 1) {
                this.m_5496_(SoundEvents.f_12384_, 1.0f, 1.0f);
            }
            if (this.attackTicks == 8) {
                this.AreaAttack(4.0f, 3.0f, 150.0f, 8.0f);
            }
        }
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.dragonDeathTime = 0;
        this.setAttackState(3);
        SpikebugEntity spikebugEntity2 = new SpikebugEntity((EntityType<? extends Monster>)((EntityType)ModEntities.Spiky_bug.get()), this.m_9236_());
        SpikebugEntity spikebugEntity1 = new SpikebugEntity((EntityType<? extends Monster>)((EntityType)ModEntities.Spiky_bug.get()), this.m_9236_());
        SpikebugEntity spikebugEntity = new SpikebugEntity((EntityType<? extends Monster>)((EntityType)ModEntities.Spiky_bug.get()), this.m_9236_());
        spikebugEntity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        spikebugEntity.m_20334_(0.0, 0.0, 0.0);
        this.m_9236_().m_7967_((Entity)spikebugEntity);
        spikebugEntity1.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        spikebugEntity1.m_20334_(0.0, 0.0, 0.0);
        this.m_9236_().m_7967_((Entity)spikebugEntity1);
        spikebugEntity2.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        spikebugEntity2.m_20334_(0.0, 0.0, 0.0);
        this.m_9236_().m_7967_((Entity)spikebugEntity2);
        ItemStack diamond = new ItemStack((ItemLike)ModItems.CHISELED_ANCIENT_DRIPTONE_SHARD.get(), 1);
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
        this.m_19983_(emerald);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (((Boolean)ModConfig.MOB_CONFIG.Ambushprojectile.get()).booleanValue() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.AmbusherHealthMutliplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.AmbusherDamageMultiplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 50.0;
        double baseAttackDamage = 8.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    protected void m_6153_() {
        ++this.dragonDeathTime;
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        if (this.m_9236_() instanceof ServerLevel && this.dragonDeathTime > 1 && !this.m_20067_()) {
            this.m_21557_(true);
            if (this.dragonDeathTime == 20 && this.m_9236_() instanceof ServerLevel) {
                ItemStack diamond = new ItemStack((ItemLike)ModItems.CHISELED_ANCIENT_DRIPTONE_SHARD.get(), 1);
                ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
                this.m_142687_(Entity.RemovalReason.KILLED);
                this.m_146850_(GameEvent.f_223707_);
            }
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "toungue") {
            return this.toungueAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.toungueAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.idleAnimationState.m_216973_();
        this.toungueAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
    }
}

