/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.integration;

import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.config.IWailaConfig;

@WailaPlugin
public class ShoulderSurfingJadePlugin
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.addRayTraceCallback((JadeRayTraceCallback)new ShoulderSurfingRayTraceCallback(registration));
    }

    private static class ShoulderSurfingRayTraceCallback
    implements JadeRayTraceCallback {
        private final IWailaClientRegistration registration;

        public ShoulderSurfingRayTraceCallback(IWailaClientRegistration registration) {
            this.registration = registration;
        }

        @Nullable
        public Accessor<?> onRayTrace(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
            ShoulderSurfingImpl instance = ShoulderSurfingImpl.getInstance();
            Minecraft minecraft = Minecraft.m_91087_();
            if (instance.isShoulderSurfing() && minecraft.f_91072_ != null && minecraft.f_91073_ != null) {
                Camera camera = minecraft.f_91063_.m_109153_();
                MultiPlayerGameMode gameMode = minecraft.f_91072_;
                ClipContext.Fluid fluidContext = IWailaConfig.get().getGeneral().getDisplayFluids().ctx;
                double interactionRangeOverride = gameMode.m_105286_() + IWailaConfig.get().getGeneral().getReachDistance();
                float partialTick = minecraft.m_91296_();
                PickContext pickContext = new PickContext.Builder(camera).withFluidContext(fluidContext).build();
                HitResult target = instance.getObjectPicker().pick(pickContext, interactionRangeOverride, partialTick, gameMode);
                LocalPlayer player = minecraft.f_91074_;
                ClientLevel level = minecraft.f_91073_;
                if (HitResult.Type.MISS.equals((Object)target.m_6662_())) {
                    return null;
                }
                if (target instanceof BlockHitResult) {
                    BlockHitResult blockTarget = (BlockHitResult)target;
                    BlockState state = level.m_8055_(blockTarget.m_82425_());
                    BlockEntity tileEntity = level.m_7702_(blockTarget.m_82425_());
                    return this.registration.blockAccessor().blockState(state).blockEntity(tileEntity).level((Level)level).player((Player)player).serverData(this.registration.getServerData()).serverConnected(this.registration.isServerConnected()).hit(blockTarget).fakeBlock(this.registration.getBlockCamouflage((LevelAccessor)level, blockTarget.m_82425_())).build();
                }
                if (target instanceof EntityHitResult) {
                    EntityHitResult entityTarget = (EntityHitResult)target;
                    return this.registration.entityAccessor().level((Level)level).player((Player)player).serverData(this.registration.getServerData()).serverConnected(this.registration.isServerConnected()).hit(entityTarget).entity(entityTarget.m_82443_()).build();
                }
            }
            return accessor;
        }
    }
}

