/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;

public class ChargeMeleeAttackGoal
extends Goal {
    protected final AnimatedCreatureEntity mob;
    private final int attackDuration;
    private final int actionPoint;
    private final int goalCoolDown;
    private final double minDistance;
    private final double speedModifier;
    private final double chargeCorrectionAngle;
    private final boolean mayDisableShield;
    private int updatePathTick;
    private Path path;
    private boolean pathUpdated;
    private int attackAnimationTick;
    private boolean hasAttacked;
    private long lastUseTime;
    private Vec3 chargeAxe;
    private BlockPos targetBlockPos;
    private int checkPosTick;
    private BlockPos oldPos;
    private boolean shouldStopAttack;

    public ChargeMeleeAttackGoal(AnimatedCreatureEntity mob, int attackDuration, int hurtTick, int goalCoolDown, double minDistanceAttack, double speedModifier, double chargeCorrectionAngle, boolean mayDisableShield) {
        this.mob = mob;
        this.attackDuration = (int)Math.ceil((double)attackDuration / 2.0);
        this.actionPoint = hurtTick / 2;
        this.goalCoolDown = goalCoolDown;
        this.minDistance = minDistanceAttack;
        this.speedModifier = speedModifier;
        this.chargeCorrectionAngle = chargeCorrectionAngle;
        this.mayDisableShield = mayDisableShield;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean isAttacking() {
        return this.mob.getAttackAnimation() == 2;
    }

    public boolean m_8036_() {
        long time = this.mob.m_9236_().m_46467_();
        if (time - this.lastUseTime < (long)this.goalCoolDown || this.isAttacking()) {
            return false;
        }
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)target, 0);
        return this.path != null && this.mob.m_21574_().m_148306_((Entity)target) && this.mob.m_20280_((Entity)target) > this.minDistance * this.minDistance;
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (this.shouldStopAttack) {
            return false;
        }
        return !this.hasAttacked;
    }

    public void m_8056_() {
        this.mob.setAttackAnimation(3);
        this.mob.m_21561_(true);
        this.attackAnimationTick = 0;
        this.hasAttacked = false;
        this.updatePathTick = 0;
        this.pathUpdated = false;
        this.chargeAxe = Vec3.f_82478_;
        this.targetBlockPos = BlockPos.f_121853_;
        this.checkPosTick = 0;
        this.oldPos = this.mob.m_20183_();
        this.shouldStopAttack = false;
    }

    public void m_8041_() {
        this.lastUseTime = this.mob.m_9236_().m_46467_();
        if (this.isAttacking()) {
            this.stopAttack();
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null) {
            if (this.checkPosTick++ > 30) {
                this.checkPosTick = 0;
                this.shouldStopAttack = this.mob.m_20183_().m_252807_().m_82557_(this.oldPos.m_252807_()) <= 1.0;
                this.oldPos = this.mob.m_20183_();
            }
            if (this.chargeAxe == Vec3.f_82478_) {
                this.chargeAxe = this.mob.m_20182_().m_82546_(target.m_20182_());
            }
            if (this.targetBlockPos == BlockPos.f_121853_) {
                this.targetBlockPos = target.m_20183_();
            }
            double distToTargetSqr = this.mob.m_20280_((Entity)target);
            double angleToTarget = this.getAngleToChargeAxe(target);
            if (this.mob.m_21574_().m_148306_((Entity)target) && angleToTarget <= this.chargeCorrectionAngle && target.m_20183_() != this.targetBlockPos && !this.isAttacking() && !this.hasAttacked) {
                this.targetBlockPos = target.m_20183_();
                this.pathUpdated = false;
            }
            if (!this.hasAttacked) {
                if (!this.mob.m_9236_().m_5776_()) {
                    ((ServerLevel)this.mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), 5, (double)(this.mob.m_20205_() / 4.0f), 0.0, (double)(this.mob.m_20205_() / 4.0f), 0.01);
                }
                if (this.mob.m_9236_().m_46467_() % 2L == 0L) {
                    this.mob.m_5496_(SoundEvents.f_11963_, 0.5f, (this.mob.m_217043_().m_188501_() - this.mob.m_217043_().m_188501_()) * 0.2f + 1.0f);
                }
            }
            if (this.getAttackReachSqr(target) / 2.0 < distToTargetSqr) {
                if (--this.updatePathTick <= 0 && !this.pathUpdated) {
                    this.pathUpdated = true;
                    if (this.move()) {
                        this.updatePathTick = 1 + this.mob.m_217043_().m_188503_(5);
                    }
                    if (distToTargetSqr > 1024.0) {
                        this.updatePathTick += 20;
                    } else if (distToTargetSqr > 256.0) {
                        this.updatePathTick += 10;
                    }
                }
            } else {
                this.mob.m_21573_().m_26573_();
            }
            if ((this.getAttackReachSqr(target) >= distToTargetSqr || this.path.m_77399_() >= this.path.m_77398_() - 1 && angleToTarget > this.chargeCorrectionAngle) && !this.isAttacking() && !this.hasAttacked) {
                this.startAttack();
            }
            if (this.attackAnimationTick > 0) {
                --this.attackAnimationTick;
            }
            if (this.attackAnimationTick == 0 && this.isAttacking()) {
                this.stopAttack();
            }
            if (this.isActionPoint()) {
                this.executeAttack(target);
            }
        }
    }

    protected void startAttack() {
        this.mob.setAttackAnimation(2);
        this.attackAnimationTick = this.attackDuration;
    }

    protected void stopAttack() {
        this.mob.setAttackAnimation(0);
        this.hasAttacked = true;
    }

    protected void executeAttack(LivingEntity target) {
        if (target != null) {
            this.doHurt(target);
        }
    }

    protected double getAttackReachSqr(LivingEntity entity) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + entity.m_20205_();
    }

    protected boolean isActionPoint() {
        return this.attackAnimationTick == this.attackDuration - this.actionPoint;
    }

    protected double getAngleToChargeAxe(LivingEntity target) {
        Vec3 currentPosToTargetVector = this.mob.m_20182_().m_82546_(target.m_20182_());
        return Math.acos(currentPosToTargetVector.m_82526_(this.chargeAxe) / (currentPosToTargetVector.m_82553_() * this.chargeAxe.m_82553_())) / Math.PI * 180.0;
    }

    protected boolean move() {
        Path path = this.mob.m_21573_().m_7864_(this.targetBlockPos, 0);
        if (path != null) {
            this.path = path;
        }
        return path != null && this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
    }

    protected void doHurt(LivingEntity target) {
        float damage = (float)this.mob.m_21133_(Attributes.f_22281_);
        float knockBack = Mth.m_14036_((float)(this.mob.m_6113_() / 0.7f), (float)0.2f, (float)3.0f);
        boolean flag = target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), damage);
        if (target instanceof Player) {
            Player player;
            this.mayDisableShield(player, (player = (Player)target).m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
        }
        if (flag) {
            target.m_147240_((double)knockBack, this.chargeAxe.f_82479_, this.chargeAxe.f_82481_);
            double knockBackResistance = Math.max(0.0, 1.0 - target.m_21133_(Attributes.f_22278_));
            target.m_20256_(target.m_20184_().m_82520_(0.0, (double)0.4f * knockBackResistance, 0.0));
            this.mob.m_21335_((Entity)target);
        }
    }

    protected void mayDisableShield(Player player, ItemStack handItem) {
        if (this.mayDisableShield && !handItem.m_41619_() && handItem.m_41720_() == Items.f_42740_) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this.mob) * 0.05f;
            if (this.mob.m_217043_().m_188501_() < f) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                this.mob.m_9236_().m_7605_((Entity)player, (byte)30);
            }
        }
    }
}

