/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sfiomn.legendarycreatures.config.Config;
import sfiomn.legendarycreatures.config.json.JsonConfigRegistration;
import sfiomn.legendarycreatures.entities.render.BullfrogRenderer;
import sfiomn.legendarycreatures.entities.render.ButterflyRenderer;
import sfiomn.legendarycreatures.entities.render.CorpseEaterRenderer;
import sfiomn.legendarycreatures.entities.render.DesertMojoRenderer;
import sfiomn.legendarycreatures.entities.render.DragonflyRenderer;
import sfiomn.legendarycreatures.entities.render.EnderWispPurseRenderer;
import sfiomn.legendarycreatures.entities.render.EnderWispRenderer;
import sfiomn.legendarycreatures.entities.render.ForestMojoRenderer;
import sfiomn.legendarycreatures.entities.render.HermitCrabRenderer;
import sfiomn.legendarycreatures.entities.render.HoundRenderer;
import sfiomn.legendarycreatures.entities.render.LadybugRenderer;
import sfiomn.legendarycreatures.entities.render.MantisRenderer;
import sfiomn.legendarycreatures.entities.render.NetherWispPurseRenderer;
import sfiomn.legendarycreatures.entities.render.NetherWispRenderer;
import sfiomn.legendarycreatures.entities.render.PeacockSpiderRenderer;
import sfiomn.legendarycreatures.entities.render.ScarabRenderer;
import sfiomn.legendarycreatures.entities.render.ScarecrowRenderer;
import sfiomn.legendarycreatures.entities.render.ScorpionBabyRenderer;
import sfiomn.legendarycreatures.entities.render.ScorpionRenderer;
import sfiomn.legendarycreatures.entities.render.WispPurseRenderer;
import sfiomn.legendarycreatures.entities.render.WispRenderer;
import sfiomn.legendarycreatures.items.render.model.StrawHatModel;
import sfiomn.legendarycreatures.level.gen.ModEntityPlacement;
import sfiomn.legendarycreatures.particles.CorpseSplatter;
import sfiomn.legendarycreatures.particles.CrowsParticle;
import sfiomn.legendarycreatures.particles.DesertMojoParticle;
import sfiomn.legendarycreatures.particles.WispParticle;
import sfiomn.legendarycreatures.registry.BlockRegistry;
import sfiomn.legendarycreatures.registry.CreativeTabRegistry;
import sfiomn.legendarycreatures.registry.EffectRegistry;
import sfiomn.legendarycreatures.registry.EntityTypeRegistry;
import sfiomn.legendarycreatures.registry.ItemRegistry;
import sfiomn.legendarycreatures.registry.ParticleTypeRegistry;
import sfiomn.legendarycreatures.registry.SoundRegistry;
import software.bernie.geckolib.GeckoLib;

@Mod(value="legendarycreatures")
public class LegendaryCreatures {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "legendarycreatures";
    public static MobCategory LEGENDARY_HOSTILE_CREATURE = MobCategory.create((String)"legendary_hostile_creature", (String)"LEGENDARY_HOSTILE_CREATURE", (int)3, (boolean)false, (boolean)false, (int)128);
    public static boolean optifineLoaded = false;
    public static boolean oculusLoaded = false;
    public static boolean atmosphericLoaded = false;
    public static boolean xpFromHarvestLoaded = false;
    public static Path configPath = FMLPaths.CONFIGDIR.get();
    public static Path modConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "legendarycreatures");
    public static Path modConfigJson = Paths.get(modConfigPath.toString(), "json");

    public LegendaryCreatures() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        BlockRegistry.register(modBus);
        EffectRegistry.register(modBus);
        EntityTypeRegistry.register(modBus);
        ItemRegistry.register(modBus);
        ParticleTypeRegistry.register(modBus);
        SoundRegistry.register(modBus);
        CreativeTabRegistry.register(modBus);
        Config.register();
        modBus.addListener(this::setup);
        GeckoLib.initialize();
        forgeBus.addListener(this::onModConfigLoadEvent);
        forgeBus.register((Object)this);
        this.modIntegration();
    }

    private void modIntegration() {
        atmosphericLoaded = ModList.get().isLoaded("atmospheric");
        oculusLoaded = ModList.get().isLoaded("oculus");
        xpFromHarvestLoaded = ModList.get().isLoaded("xpfromharvest");
        if (atmosphericLoaded) {
            LOGGER.debug("Atmospheric is loaded, enabling compatibility");
        }
        if (oculusLoaded) {
            LOGGER.debug("Oculus is loaded, enabling compatibility");
        }
        if (xpFromHarvestLoaded) {
            LOGGER.debug("XpFromHarvest is loaded, enabling compatibility");
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        Config.Baked.bakeCommon();
        JsonConfigRegistration.init(modConfigJson.toFile());
        event.enqueueWork(ModEntityPlacement::spawnPlacement);
    }

    private void onModConfigLoadEvent(ModConfigEvent.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == Config.COMMON_SPEC) {
            Config.Baked.bakeCommon();
        }
    }

    @Mod.EventBusSubscriber(modid="legendarycreatures", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            try {
                Class.forName("net.optifine.Config");
                optifineLoaded = true;
            }
            catch (ClassNotFoundException e) {
                optifineLoaded = false;
            }
            if (optifineLoaded) {
                LOGGER.debug("Optifine is loaded, disabling custom glowing shader");
            }
        }

        @SubscribeEvent
        public static void onRegisterEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.DESERT_MOJO.get(), DesertMojoRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.FOREST_MOJO.get(), ForestMojoRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.HOUND.get(), HoundRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.SCARECROW.get(), ScarecrowRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.SCORPION.get(), ScorpionRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.SCORPION_BABY.get(), ScorpionBabyRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.WISP.get(), WispRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.NETHER_WISP.get(), NetherWispRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.ENDER_WISP.get(), EnderWispRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.WISP_PURSE.get(), WispPurseRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.NETHER_WISP_PURSE.get(), NetherWispPurseRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.ENDER_WISP_PURSE.get(), EnderWispPurseRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.CORPSE_EATER.get(), CorpseEaterRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.PEACOCK_SPIDER.get(), PeacockSpiderRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.BULLFROG.get(), BullfrogRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.BUTTERFLY.get(), ButterflyRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.DRAGONFLY.get(), DragonflyRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.LADYBUG.get(), LadybugRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.SCARAB.get(), ScarabRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.MANTIS.get(), MantisRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTypeRegistry.HERMIT_CRAB.get(), HermitCrabRenderer::new);
        }

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ParticleTypeRegistry.CORPSE_SPLATTER.get(), CorpseSplatter.Factory::new);
            event.registerSpriteSet((ParticleType)ParticleTypeRegistry.WISP_PARTICLE.get(), WispParticle.Factory::new);
            event.registerSpriteSet((ParticleType)ParticleTypeRegistry.DESERT_MOJO_PARTICLE.get(), DesertMojoParticle.Factory::new);
            event.registerSpriteSet((ParticleType)ParticleTypeRegistry.CROWS_PARTICLE.get(), CrowsParticle.Factory::new);
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(StrawHatModel.LAYER_LOCATION, StrawHatModel::createBodyLayer);
        }
    }
}

