/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class TerrestrialAgglomerationPlateBlockEntity
extends BotaniaBlockEntity
implements SparkAttachable,
ManaReceiver {
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"___", "_P_", "___"}, {"RLR", "L0L", "RLR"}}, new Object[]{Character.valueOf('P'), BotaniaBlocks.terraPlate, Character.valueOf('R'), PatchouliAPI.get().tagMatcher(BotaniaTags.Blocks.TERRA_PLATE_BASE), Character.valueOf('0'), PatchouliAPI.get().tagMatcher(BotaniaTags.Blocks.TERRA_PLATE_BASE), Character.valueOf('L'), PatchouliAPI.get().tagMatcher(XplatAbstractions.INSTANCE.isFabric() ? TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("c", "lapis_blocks")) : TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("forge", "storage_blocks/lapis")))}));
    private static final String TAG_MANA = "mana";
    private int mana;

    public TerrestrialAgglomerationPlateBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.TERRA_PLATE, pos, state);
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, TerrestrialAgglomerationPlateBlockEntity self) {
        boolean removeMana = true;
        if (self.hasValidPlatform()) {
            List<ItemEntity> itemEntities = self.getItemEntities();
            List<ItemStack> items = self.getItems(itemEntities);
            SimpleContainer inv = self.getInventory(itemEntities);
            TerrestrialAgglomerationRecipe recipe = self.getCurrentRecipe(inv);
            if (recipe != null) {
                removeMana = false;
                ManaSpark spark = self.getAttachedSpark();
                if (spark != null) {
                    List<ManaSpark> otherSparks = SparkHelper.getSparksAround(level, (double)worldPosition.m_123341_() + 0.5, (double)worldPosition.m_123342_() + 0.5, (double)worldPosition.m_123343_() + 0.5, spark.getNetwork());
                    for (ManaSpark manaSpark : otherSparks) {
                        if (spark == manaSpark || !(manaSpark.getAttachedManaReceiver() instanceof ManaPool)) continue;
                        manaSpark.registerTransfer(spark);
                    }
                }
                if (self.mana > 0) {
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
                    int proportion = Float.floatToIntBits(self.getCompletion());
                    XplatAbstractions.INSTANCE.sendToNear(level, worldPosition, new BotaniaEffectPacket(EffectType.TERRA_PLATE, worldPosition.m_123341_(), worldPosition.m_123342_(), worldPosition.m_123343_(), proportion));
                }
                if (self.mana >= recipe.getMana()) {
                    Player player = TerrestrialAgglomerationPlateBlockEntity.getCraftingPlayer(itemEntities);
                    ItemStack result = recipe.m_5874_((Container)inv, level.m_9598_());
                    if (player != null) {
                        player.m_280300_((Recipe)recipe, List.of(result));
                        result.m_41678_(level, player, result.m_41613_());
                    }
                    for (ItemStack item : items) {
                        item.m_41764_(0);
                    }
                    ItemEntity itemEntity = new ItemEntity(level, (double)worldPosition.m_123341_() + 0.5, (double)worldPosition.m_123342_() + 0.2, (double)worldPosition.m_123343_() + 0.5, result);
                    itemEntity.m_20256_(Vec3.f_82478_);
                    level.m_7967_((Entity)itemEntity);
                    level.m_6263_(null, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), BotaniaSounds.terrasteelCraft, SoundSource.BLOCKS, 1.0f, 1.0f);
                    self.mana = 0;
                    level.m_46717_(worldPosition, state.m_60734_());
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
                }
            }
        }
        if (removeMana) {
            self.receiveMana(-1000);
        }
    }

    @Nullable
    private static Player getCraftingPlayer(List<ItemEntity> itemEntities) {
        Player player = null;
        int minAge = Integer.MAX_VALUE;
        for (ItemEntity entity : itemEntities) {
            Entity entity2 = entity.m_19749_();
            if (!(entity2 instanceof Player)) continue;
            Player owner = (Player)entity2;
            if (entity.m_32059_() >= minAge) continue;
            player = owner;
            minAge = entity.m_32059_();
        }
        return player;
    }

    private List<ItemStack> getItems(List<ItemEntity> itemEntities) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemEntity entity : itemEntities) {
            if (entity.m_32055_().m_41619_()) continue;
            stacks.add(entity.m_32055_());
        }
        return stacks;
    }

    private List<ItemEntity> getItemEntities() {
        return this.f_58857_.m_6443_(ItemEntity.class, new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 1, 1)), EntitySelector.f_20402_);
    }

    private SimpleContainer getInventory(List<ItemEntity> itemEntities) {
        return new SimpleContainer(TerrestrialAgglomerationPlateBlockEntity.flattenStacks(this.getItems(itemEntities)));
    }

    private static ItemStack[] flattenStacks(List<ItemStack> items) {
        int i = 0;
        for (ItemStack item : items) {
            i += item.m_41613_();
        }
        if (i > 64) {
            return new ItemStack[0];
        }
        ItemStack[] stacks = new ItemStack[i];
        int j = 0;
        for (ItemStack item : items) {
            if (item.m_41613_() > 1) {
                ItemStack temp = item.m_255036_(1);
                for (int count = 0; count < item.m_41613_(); ++count) {
                    stacks[j] = temp.m_41777_();
                    ++j;
                }
                continue;
            }
            stacks[j] = item;
            ++j;
        }
        return stacks;
    }

    @Nullable
    private TerrestrialAgglomerationRecipe getCurrentRecipe(SimpleContainer items) {
        if (items.m_7983_()) {
            return null;
        }
        return this.f_58857_.m_7465_().m_44015_(BotaniaRecipeTypes.TERRA_PLATE_TYPE, (Container)items, this.f_58857_).orElse(null);
    }

    private boolean isActive() {
        return this.getCurrentRecipe(this.getInventory(this.getItemEntities())) != null;
    }

    private boolean hasValidPlatform() {
        return MULTIBLOCK.get().validate(this.f_58857_, this.m_58899_().m_7495_()) != null;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.mana = cmp.m_128451_(TAG_MANA);
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        TerrestrialAgglomerationRecipe recipe = this.getCurrentRecipe(this.getInventory(this.getItemEntities()));
        return recipe == null || this.getCurrentMana() >= recipe.getMana();
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.max(0, this.mana + mana);
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return this.isActive();
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public ManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_7918_(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return !this.isActive();
    }

    @Override
    public int getAvailableSpaceForMana() {
        TerrestrialAgglomerationRecipe recipe = this.getCurrentRecipe(this.getInventory(this.getItemEntities()));
        return recipe == null ? 0 : Math.max(0, recipe.getMana() - this.getCurrentMana());
    }

    public float getCompletion() {
        TerrestrialAgglomerationRecipe recipe = this.getCurrentRecipe(this.getInventory(this.getItemEntities()));
        if (recipe == null) {
            return 0.0f;
        }
        return (float)this.getCurrentMana() / (float)recipe.getMana();
    }

    public int getComparatorLevel() {
        int val = (int)((double)this.getCompletion() * 15.0);
        if (this.getCurrentMana() > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }
}

