/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class SortSelector {
    public static Comparator<ItemStack> getSortTypeComparator(List<ItemStack> stacks, SortType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SortType.CATEGORY -> Comparator.comparing(SortSelector::getStringForCategorySort);
            case SortType.NAME -> Comparator.comparing(SortSelector::getStringForNameSort);
            case SortType.COUNT -> SortSelector.getCountTypeComparator(stacks);
        };
    }

    public static Comparator<ItemStack> getCountTypeComparator(List<ItemStack> stacks) {
        HashMap<Item, Integer> counts = SortSelector.calculateCount(stacks);
        ArrayList<Item> sortedItems = new ArrayList<Item>(counts.keySet());
        sortedItems.sort((item1, item2) -> {
            int countCompare = Integer.compare((Integer)counts.get(item2), (Integer)counts.get(item1));
            if (countCompare != 0) {
                return countCompare;
            }
            return item1.m_5524_().compareTo(item2.m_5524_());
        });
        return (stack1, stack2) -> {
            if (stack1.m_41619_() && stack2.m_41619_()) {
                return 0;
            }
            if (stack1.m_41619_()) {
                return 1;
            }
            if (stack2.m_41619_()) {
                return -1;
            }
            int index1 = sortedItems.indexOf(stack1.m_41720_());
            int index2 = sortedItems.indexOf(stack2.m_41720_());
            return Integer.compare(index1, index2);
        };
    }

    public static HashMap<Item, Integer> calculateCount(List<ItemStack> stacks) {
        HashMap<Item, Integer> itemCounts = new HashMap<Item, Integer>();
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            int count = stack.m_41613_();
            itemCounts.put(item, itemCounts.getOrDefault(item, 0) + count);
        }
        return itemCounts;
    }

    public static String getStringForCategorySort(ItemStack stack) {
        String name = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
        name = SortSelector.specialCases(stack, name);
        return name;
    }

    public static String getStringForNameSort(ItemStack stack) {
        String key = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
        String itemName = key.split(":")[1];
        itemName = SortSelector.specialCases(stack, itemName);
        return itemName;
    }

    private static String specialCases(ItemStack stack, String name) {
        Item item = stack.m_41720_();
        name = SortSelector.stackSize(stack, name);
        if (item instanceof EnchantedBookItem) {
            return SortSelector.enchantedBookNameCase(stack, name);
        }
        if (item instanceof TieredItem) {
            return SortSelector.toolDurabilityCase(stack, name);
        }
        return name;
    }

    private static String stackSize(ItemStack stack, String name) {
        int invertedCount = 9999 - stack.m_41613_();
        return name + String.format("%04d", invertedCount);
    }

    private static String enchantedBookNameCase(ItemStack stack, String name) {
        ListTag enchants = EnchantedBookItem.m_41163_((ItemStack)stack);
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder enchantNames = new StringBuilder();
        for (int i = 0; i < enchants.size(); ++i) {
            Enchantment enchant;
            CompoundTag enchantTag = enchants.m_128728_(i);
            ResourceLocation enchantID = ResourceLocation.m_135820_((String)enchantTag.m_128461_("id"));
            if (enchantID == null || (enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantID)) == null) continue;
            names.add(enchant.m_44700_(enchantTag.m_128451_("lvl")).getString());
        }
        Collections.sort(names);
        for (String enchant : names) {
            enchantNames.append(enchant).append(" ");
        }
        return name + " " + enchants.size() + " " + String.valueOf(enchantNames);
    }

    private static String toolDurabilityCase(ItemStack stack, String name) {
        return name + stack.m_41773_();
    }

    public static enum SortType {
        CATEGORY,
        NAME,
        COUNT;


        public SortType next() {
            SortType[] values = SortType.values();
            int nextIndex = (this.ordinal() + 1) % values.length;
            return values[nextIndex];
        }
    }
}

