/*
 * Decompiled with CFR 0.152.
 */
package dev.the_millman.christmasfestivity.common.blocks;

import com.google.common.collect.ImmutableMap;
import dev.the_millman.christmasfestivity.core.util.ProprertyCollection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LightWallBlock
extends Block {
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final IntegerProperty NUMBER = ProprertyCollection.NUMBER;
    private static VoxelShape SHAPE_N = Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)10.0, (double)2.5);
    private static VoxelShape SHAPE_S = Block.m_49796_((double)0.0, (double)5.0, (double)13.5, (double)16.0, (double)10.0, (double)16.0);
    private static VoxelShape SHAPE_W = Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)2.5, (double)10.0, (double)16.0);
    private static VoxelShape SHAPE_E = Block.m_49796_((double)13.5, (double)5.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(property -> property.getKey() != Direction.DOWN).collect(Util.m_137448_());

    public LightWallBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NUMBER, (Comparable)Integer.valueOf(0))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().collect(Collectors.toMap(Function.identity(), LightWallBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = Shapes.m_83040_();
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SHAPE_N);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SHAPE_S);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SHAPE_E);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SHAPE_W);
        }
        return voxelshape.m_83281_() ? Shapes.m_83144_() : voxelshape;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState);
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return this.hasFaces(this.getUpdatedState(pState, (BlockGetter)pLevel, pPos));
    }

    private boolean hasFaces(BlockState pState) {
        return this.countFaces(pState) > 0;
    }

    private int countFaces(BlockState pState) {
        int i = 0;
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)pState.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        if (pDirection == Direction.DOWN || pDirection == Direction.UP) {
            return false;
        }
        BlockPos blockpos = pPos.m_121945_(pDirection);
        if (LightWallBlock.isAcceptableNeighbour(pLevel, blockpos, pDirection)) {
            return true;
        }
        if (pDirection.m_122434_() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(pDirection);
        BlockState blockstate = pLevel.m_8055_(pPos.m_7494_());
        return blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
    }

    public static boolean isAcceptableNeighbour(BlockGetter pBlockReader, BlockPos pLevel, Direction pNeighborPos) {
        BlockState blockstate = pBlockReader.m_8055_(pLevel);
        return Block.m_49918_((VoxelShape)blockstate.m_60812_(pBlockReader, pLevel), (Direction)pNeighborPos.m_122424_());
    }

    private BlockState getUpdatedState(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7494_();
        if (((Boolean)pState.m_61143_((Property)UP)).booleanValue()) {
            pState = (BlockState)pState.m_61124_((Property)UP, (Comparable)Boolean.valueOf(LightWallBlock.isAcceptableNeighbour(pLevel, blockpos, Direction.DOWN)));
        }
        BlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = LightWallBlock.getPropertyForFace(direction);
            if (!((Boolean)pState.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(pLevel, pPos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = pLevel.m_8055_(blockpos);
                }
                flag = blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            }
            pState = (BlockState)pState.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return pState;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == Direction.DOWN) {
            return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        BlockState blockstate = this.getUpdatedState(pState, (BlockGetter)pLevel, pCurrentPos);
        return !this.hasFaces(blockstate) ? Blocks.f_50016_.m_49966_() : blockstate;
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        BlockState blockstate = pUseContext.m_43725_().m_8055_(pUseContext.m_8083_());
        ItemStack stack = pUseContext.m_43723_().m_21205_();
        boolean flag = stack.m_150930_(this.m_5456_());
        if (blockstate.m_60713_((Block)this) && flag) {
            return this.countFaces(blockstate) < PROPERTY_BY_DIRECTION.size();
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_());
        boolean flag = blockstate.m_60713_((Block)this);
        BlockState blockstate1 = flag ? blockstate : this.m_49966_();
        for (Direction direction : pContext.m_6232_()) {
            boolean flag1;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanproperty = LightWallBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((BlockGetter)pContext.m_43725_(), pContext.m_8083_(), direction)) continue;
            return (BlockState)((BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NUMBER, (Comparable)Integer.valueOf((Integer)blockstate1.m_61143_((Property)NUMBER) + 1));
        }
        return flag ? blockstate1 : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{UP, NORTH, EAST, SOUTH, WEST, NUMBER});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotate) {
        switch (pRotate) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)));
            }
        }
        return pState;
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        switch (pMirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)pState.m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(pState, pMirror);
    }

    public static BooleanProperty getPropertyForFace(Direction pFace) {
        return PROPERTY_BY_DIRECTION.get(pFace);
    }
}

