/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.obscuria.obscureapi.ObscureAPIConfig;
import com.obscuria.obscureapi.api.hekate.HekateLib;
import com.obscuria.obscureapi.common.PatreonLayerMode;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PatreonLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final ResourceLocation LOCATION = new ResourceLocation("obscure_api", "textures/fox.png");
    private final Model<AbstractClientPlayer> MODEL;

    public PatreonLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer, EntityModelSet modelSet) {
        super(renderer);
        this.MODEL = new Model(modelSet.m_171103_(Model.LAYER_LOCATION));
    }

    public void render(@Nonnull PoseStack pose, @Nonnull MultiBufferSource source, int light, @Nonnull AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float headYaw, float headPitch) {
        if (!((PatreonLayerMode)((Object)ObscureAPIConfig.Client.petMode.get())).shouldDisplay((Player)Minecraft.m_91087_().f_91074_, (Player)player)) {
            return;
        }
        pose.m_85836_();
        pose.m_85841_(0.7f, 0.7f, 0.7f);
        pose.m_85837_(-0.9, 0.0, 0.6);
        this.MODEL.m_6973_(player, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        this.MODEL.m_7695_(pose, source.m_6299_(RenderType.m_110431_((ResourceLocation)LOCATION)), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
    }

    public static class Model<T extends Entity>
    extends EntityModel<T> {
        public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("obscure_api", "patreon"), "main");
        private final ModelPart main;
        private final ModelPart head;
        private final ModelPart body;
        private final ModelPart rightPawTop;
        private final ModelPart leftPawTop;
        private final ModelPart rightPawBottom;
        private final ModelPart leftPawBottom;
        private final ModelPart tail;

        public Model(ModelPart root) {
            this.main = root.m_171324_("main");
            this.head = this.main.m_171324_("head");
            this.body = this.main.m_171324_("body");
            this.rightPawTop = this.body.m_171324_("rightPawTop");
            this.leftPawTop = this.body.m_171324_("leftPawTop");
            this.rightPawBottom = this.body.m_171324_("rightPawBottom");
            this.leftPawBottom = this.body.m_171324_("leftPawBottom");
            this.tail = this.body.m_171324_("tail");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition main = partdefinition.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
            main.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 4).m_171488_(1.75f, -7.0f, -1.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-2.75f, -7.0f, -1.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(-1.0f, -2.0f, -4.5f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -5.0f, -2.5f, 7.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-0.5f));
            PartDefinition body = main.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-2.0f, 0.0f, -1.5f, 5.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)-0.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
            body.m_171599_("rightPawTop", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)-1.5f, (float)-0.6939f, (float)-0.084f, (float)-0.1005f));
            body.m_171599_("leftPawTop", CubeListBuilder.m_171558_().m_171514_(8, 22).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)-1.5f, (float)-0.6527f, (float)0.0531f, (float)0.0693f));
            body.m_171599_("rightPawBottom", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)-1.0f, (float)4.0f, (float)-1.5f, (float)-0.5199f, (float)-0.0653f, (float)-0.1135f));
            body.m_171599_("leftPawBottom", CubeListBuilder.m_171558_().m_171514_(8, 27).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)2.0f, (float)4.0f, (float)-1.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
            body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(16, 10).m_171488_(-1.0f, -1.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
        }

        public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.main.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        }

        public void m_6973_(@Nonnull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            float speed1 = 0.1f;
            float speed2 = 0.05f;
            HekateLib.reset(this.main, this.head, this.body, this.rightPawTop, this.leftPawTop, this.rightPawBottom, this.leftPawBottom, this.tail);
            this.main.f_104201_ = HekateLib.math.idle(40.0f, 15.0f, 0.1f, 0.0f, ageInTicks);
            HekateLib.math.i(this.body, 15.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.1f, -0.1f, ageInTicks);
            HekateLib.math.i(this.tail, 12.0f, 15.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.1f, -0.2f, ageInTicks);
            HekateLib.math.i(this.body, 0.0f, 0.0f, 5.0f, 0.0f, 5.0f, 0.0f, 0.05f, -0.1f, ageInTicks);
            HekateLib.math.i(this.tail, 0.0f, 0.0f, 5.0f, 0.0f, 5.0f, 0.0f, 0.05f, -0.2f, ageInTicks);
            HekateLib.math.i(this.rightPawTop, -20.0f, 30.0f, 2.0f, 5.0f, -2.0f, -5.0f, 0.1f, -0.1f, ageInTicks);
            HekateLib.math.i(this.leftPawTop, -20.0f, 30.0f, -2.0f, -5.0f, 2.0f, 5.0f, 0.1f, -0.12f, ageInTicks);
            HekateLib.math.i(this.rightPawBottom, -20.0f, 30.0f, 2.0f, 5.0f, -2.0f, -5.0f, 0.1f, -0.14f, ageInTicks);
            HekateLib.math.i(this.leftPawBottom, -20.0f, 30.0f, -2.0f, -5.0f, 2.0f, 5.0f, 0.1f, -0.16f, ageInTicks);
            this.head.f_104203_ = HekateLib.mod.head(headPitch, 1.0f);
            this.head.f_104204_ = HekateLib.mod.head(netHeadYaw, 1.0f);
        }
    }
}

