/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffixBase;
import top.theillusivec4.champions.common.network.SPacketSyncAffixData;
import top.theillusivec4.champions.common.network.SPacketSyncAffixSetting;
import top.theillusivec4.champions.common.network.SPacketSyncChampion;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.util.Utils;

public class NetworkHandler {
    private static final String PTC_VERSION = "1";
    public static SimpleChannel INSTANCE;
    private static int id;

    public static void register() {
        INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)Utils.getLocation("main")).networkProtocolVersion(() -> PTC_VERSION).clientAcceptedVersions(PTC_VERSION::equals).serverAcceptedVersions(PTC_VERSION::equals).simpleChannel();
        NetworkHandler.register(SPacketSyncChampion.class, SPacketSyncChampion::encode, SPacketSyncChampion::decode, SPacketSyncChampion::handle);
        NetworkHandler.register(SPacketSyncAffixData.class, SPacketSyncAffixData::encode, SPacketSyncAffixData::decode, SPacketSyncAffixData::handle);
        NetworkHandler.register(SPacketSyncAffixSetting.class, SPacketSyncAffixSetting::encode, SPacketSyncAffixSetting::decode, SPacketSyncAffixSetting::handle);
    }

    private static <M> void register(Class<M> messageType, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(id++, messageType, encoder, decoder, messageConsumer);
    }

    public static void syncChampionDataToPlayerTrackingEntity(IChampion.Server championData, LivingEntity targetEntity) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> targetEntity), (Object)new SPacketSyncChampion(targetEntity.m_19879_(), championData.getRank().map(Rank::getTier).orElse(0), championData.getRank().map(Rank::getDefaultColor).orElse(TextColor.m_131266_((int)0)).m_131274_(), championData.getAffixes().stream().map(IAffixBase::getIdentifier).collect(Collectors.toSet())));
    }

    static {
        id = 0;
    }
}

