/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.util.Collections;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.affix.core.GoalAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.entity.ArcticBulletEntity;

public class ArcticAffix
extends GoalAffix {
    @Override
    public List<Tuple<Integer, Goal>> getGoals(IChampion champion) {
        return Collections.singletonList(new Tuple((Object)0, (Object)new AttackGoal((Mob)champion.getLivingEntity())));
    }

    @Override
    public AffixSetting createDefaultSetting() {
        return AffixSetting.builder().withDefault().build();
    }

    static class AttackGoal
    extends Goal {
        private final Mob mobEntity;
        private int attackTime;

        public AttackGoal(Mob mobEntity) {
            this.mobEntity = mobEntity;
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mobEntity.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                return BasicAffix.canTarget((LivingEntity)this.mobEntity, livingentity, true) && this.mobEntity.m_9236_().m_46791_() != Difficulty.PEACEFUL;
            }
            return false;
        }

        public void m_8056_() {
            this.attackTime = ChampionsConfig.arcticAttackInterval * 20;
        }

        public void m_8037_() {
            if (this.mobEntity.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                --this.attackTime;
                LivingEntity livingentity = this.mobEntity.m_5448_();
                if (livingentity != null) {
                    this.mobEntity.m_21563_().m_24960_((Entity)livingentity, 180.0f, 180.0f);
                    double sqrDistance = this.mobEntity.m_20280_((Entity)livingentity);
                    if (sqrDistance < 400.0) {
                        if (this.attackTime <= 0) {
                            this.attackTime = ChampionsConfig.arcticAttackInterval * 20 + this.mobEntity.m_217043_().m_188503_(10) * 20 / 2;
                            this.mobEntity.m_9236_().m_7967_((Entity)new ArcticBulletEntity(this.mobEntity.m_9236_(), (LivingEntity)this.mobEntity, (Entity)livingentity, this.mobEntity.m_6350_().m_122434_()));
                            this.mobEntity.m_5496_(SoundEvents.f_12417_, 2.0f, (this.mobEntity.m_217043_().m_188501_() - this.mobEntity.m_217043_().m_188501_()) * 0.2f + 1.0f);
                        }
                    } else {
                        this.mobEntity.m_6710_(null);
                    }
                }
                super.m_8037_();
            }
        }
    }
}

