/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBallEntity;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.CannonBallExplosion;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.GunpowderExplosion;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record ClientBoundExplosionPacket(Type type, Vec3 pos, float power, List<BlockPos> toBlow, @Nullable Vec3 knockback, int getId) implements Message
{
    public static ClientBoundExplosionPacket bomb(BombExplosion expl, @Nullable Player player) {
        Vec3 pos = new Vec3(expl.f_46013_, expl.f_46014_, expl.f_46015_);
        return new ClientBoundExplosionPacket(Type.BOMB, pos, expl.f_46017_, (List<BlockPos>)expl.getToBlow(), (Vec3)expl.m_46078_().get(player), expl.bombType().ordinal());
    }

    public static ClientBoundExplosionPacket cannonball(CannonBallExplosion expl, CannonBallEntity source) {
        Vec3 pos = new Vec3(expl.f_46013_, expl.f_46014_, expl.f_46015_);
        return new ClientBoundExplosionPacket(Type.CANNONBALL, pos, expl.f_46017_, expl.m_46081_(), source.m_20184_(), source.m_19879_());
    }

    public static ClientBoundExplosionPacket gunpowder(GunpowderExplosion expl) {
        Vec3 pos = new Vec3(expl.f_46013_, expl.f_46014_, expl.f_46015_);
        return new ClientBoundExplosionPacket(Type.GUNPOWDER, pos, expl.f_46017_, (List<BlockPos>)expl.getToBlow(), null, -1);
    }

    public static ClientBoundExplosionPacket fromBuffer(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        float power = buffer.readFloat();
        int i = Mth.m_14107_((double)x);
        int j = Mth.m_14107_((double)y);
        int k = Mth.m_14107_((double)z);
        List toBlow = buffer.m_236845_(friendlyByteBuf -> {
            int l = friendlyByteBuf.readByte() + i;
            int m = friendlyByteBuf.readByte() + j;
            int n = friendlyByteBuf.readByte() + k;
            return new BlockPos(l, m, n);
        });
        Vec3 knockback = buffer.readBoolean() ? new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()) : null;
        Type type = (Type)buffer.m_130066_(Type.class);
        int id = buffer.m_130242_();
        return new ClientBoundExplosionPacket(type, new Vec3(x, y, z), power, toBlow, knockback, id);
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.pos.f_82479_);
        buffer.writeDouble(this.pos.f_82480_);
        buffer.writeDouble(this.pos.f_82481_);
        buffer.writeFloat(this.power);
        int i = Mth.m_14107_((double)this.pos.f_82479_);
        int j = Mth.m_14107_((double)this.pos.f_82480_);
        int k = Mth.m_14107_((double)this.pos.f_82481_);
        buffer.m_236828_(this.toBlow, (friendlyByteBuf, blockPos) -> {
            int l = blockPos.m_123341_() - i;
            int m = blockPos.m_123342_() - j;
            int n = blockPos.m_123343_() - k;
            friendlyByteBuf.writeByte(l);
            friendlyByteBuf.writeByte(m);
            friendlyByteBuf.writeByte(n);
        });
        buffer.writeBoolean(this.knockback != null);
        if (this.knockback != null) {
            buffer.writeDouble(this.knockback.f_82479_);
            buffer.writeDouble(this.knockback.f_82480_);
            buffer.writeDouble(this.knockback.f_82481_);
        }
        buffer.m_130068_((Enum)this.type);
        buffer.m_130130_(this.getId);
    }

    public void handle(ChannelHandler.Context context) {
        ClientReceivers.handleExplosionPacket(this);
    }

    public static enum Type {
        BOMB,
        CANNONBALL,
        GUNPOWDER;

    }
}

