/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network.slot;

import com.enderio.core.common.network.slot.NetworkDataSlot;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class LongNetworkDataSlot
extends NetworkDataSlot<Long> {
    public LongNetworkDataSlot(Supplier<Long> getter, Consumer<Long> setter) {
        super(getter, setter);
    }

    @Override
    public Tag serializeValueNBT(Long value) {
        return LongTag.m_128882_((long)value);
    }

    @Override
    protected Long valueFromNBT(Tag nbt) {
        if (nbt instanceof LongTag) {
            LongTag longTag = (LongTag)nbt;
            return longTag.m_7046_();
        }
        throw new IllegalStateException("Invalid long tag was passed over the network.");
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Long value) {
        buf.writeLong(value.longValue());
    }

    @Override
    public Long valueFromBuffer(FriendlyByteBuf buf) {
        try {
            return buf.readLong();
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid long buffer was passed over the network.");
        }
    }
}

