/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.widgets;

import com.enderio.api.misc.IIcon;
import com.enderio.api.misc.Vector2i;
import com.enderio.core.EnderCore;
import com.enderio.core.client.gui.screen.IEnderScreen;
import com.enderio.core.client.gui.screen.IFullScreenListener;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EnumIconWidget<T extends Enum<T>, U extends Screen>
extends AbstractWidget
implements IFullScreenListener {
    private static final ResourceLocation BUTTON_TEXTURE = EnderCore.loc("textures/gui/checkbox.png");
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private final Map<T, SelectionWidget> icons = new HashMap<T, SelectionWidget>();
    private final Vector2i expandTopLeft;
    private final Vector2i expandBottomRight;
    private static final int ELEMENTS_IN_ROW = 5;
    private static final int SPACE_BETWEEN_ELEMENTS = 4;
    private boolean isExpanded = false;
    private boolean expandNext = false;
    private int mouseButton = 0;
    private final U addedOn;
    private final SelectionScreen selection;
    private final Component optionName;
    @Nullable
    private T tooltipDisplayCache;

    public EnumIconWidget(U addedOn, int pX, int pY, Supplier<T> getter, Consumer<T> setter, Component optionName) {
        super(pX, pY, ((IIcon)((Object)((Enum)getter.get()))).getRenderSize().x(), ((IIcon)((Object)((Enum)getter.get()))).getRenderSize().y(), (Component)Component.m_237119_());
        this.getter = getter;
        this.setter = setter;
        this.optionName = optionName;
        Enum[] values = (Enum[])((Enum)getter.get()).getDeclaringClass().getEnumConstants();
        Vector2i pos = this.calculateFirstPosition(values[0], values.length);
        Vector2i elementDistance = ((IIcon)((Object)values[0])).getRenderSize().expand(4);
        for (int i = 0; i < values.length; ++i) {
            Enum value = values[i];
            Vector2i subWidgetPos = pos.add(EnumIconWidget.getColumn(i) * elementDistance.x(), EnumIconWidget.getRow(i) * elementDistance.y()).add(pX, pY);
            SelectionWidget widget = new SelectionWidget(this, subWidgetPos, value);
            this.icons.put(value, widget);
        }
        Vector2i topLeft = Vector2i.MAX;
        Vector2i bottomRight = Vector2i.MIN;
        for (SelectionWidget widget : this.icons.values()) {
            topLeft = topLeft.withX(Math.min(topLeft.x(), widget.m_252754_()));
            topLeft = topLeft.withY(Math.min(topLeft.y(), widget.m_252907_()));
            bottomRight = bottomRight.withX(Math.max(bottomRight.x(), widget.m_252754_() + widget.m_5711_() - 2));
            bottomRight = bottomRight.withY(Math.max(bottomRight.y(), widget.m_252907_() + widget.m_93694_() - 2));
        }
        this.expandTopLeft = topLeft.expand(-4);
        this.expandBottomRight = bottomRight.expand(4);
        this.addedOn = addedOn;
        this.selection = new SelectionScreen();
    }

    private Vector2i calculateFirstPosition(T icon, int amount) {
        int maxColumns = Math.min(amount, 5);
        int width = (maxColumns - 1) * (((IIcon)icon).getRenderSize().x() + 4);
        return new Vector2i(-width / 2, 8 + ((IIcon)icon).getRenderSize().y());
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.mouseButton = pButton;
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected boolean m_7972_(int pButton) {
        return pButton == 0 || pButton == 1;
    }

    public void m_5716_(double pMouseX, double pMouseY) {
        this.selectNext(this.mouseButton != 1);
        if (!this.isExpanded) {
            this.isExpanded = true;
            Minecraft.m_91087_().pushGuiLayer((Screen)this.selection);
        }
    }

    private void selectNext(boolean isForward) {
        Enum[] values = (Enum[])((Enum)this.getter.get()).getDeclaringClass().getEnumConstants();
        int index = ((Enum)this.getter.get()).ordinal() + (isForward ? 1 : -1) + values.length;
        this.setter.accept(values[index % values.length]);
    }

    private static int getColumn(int index) {
        return index % 5;
    }

    private static int getRow(int index) {
        return index / 5;
    }

    public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.expandNext && Minecraft.m_91087_().f_91080_ == this.addedOn) {
            Minecraft.m_91087_().pushGuiLayer((Screen)this.selection);
            this.expandNext = false;
            this.isExpanded = true;
        }
        if (this.f_93622_ && this.m_142518_()) {
            ((IEnderScreen)this.addedOn).renderTooltipAfterEverything(guiGraphics, List.of(this.optionName, ((IIcon)((Object)((Enum)this.getter.get()))).getTooltip().m_6881_().m_130940_(ChatFormatting.GRAY)), pMouseX, pMouseY);
        }
        Enum icon = (Enum)this.getter.get();
        guiGraphics.m_280411_(BUTTON_TEXTURE, this.m_252754_(), this.m_252907_(), ((IIcon)((Object)icon)).getIconSize().x(), ((IIcon)((Object)icon)).getIconSize().y(), this.f_93622_ || this.isExpanded ? 28.0f : 0.0f, 0.0f, 14, 14, 256, 256);
        IEnderScreen.renderIcon(guiGraphics, new Vector2i(this.m_252754_(), this.m_252907_()), (IIcon)((Object)icon));
        if (this.m_198029_() && this.tooltipDisplayCache != this.getter.get()) {
            this.tooltipDisplayCache = (Enum)this.getter.get();
            this.m_257544_(Tooltip.m_257550_((Component)this.optionName.m_6881_().m_130946_("\n").m_7220_((Component)((IIcon)((Object)((Enum)this.getter.get()))).getTooltip().m_6881_().m_130940_(ChatFormatting.GRAY))));
        }
    }

    protected ClientTooltipPositioner m_262860_() {
        return DefaultTooltipPositioner.f_262752_;
    }

    public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    @Override
    public void onGlobalClick(double mouseX, double mouseY) {
        if (!(!this.isExpanded || (double)this.expandTopLeft.x() <= mouseX && (double)this.expandBottomRight.x() >= mouseX && (double)this.expandTopLeft.y() <= mouseY && (double)this.expandBottomRight.y() >= mouseY || this.m_5953_(mouseX, mouseY))) {
            this.isExpanded = false;
            Minecraft.m_91087_().popGuiLayer();
        }
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(Boolean expanded) {
        this.expandNext = expanded;
        this.isExpanded = expanded;
    }

    public Component getOptionName() {
        return this.optionName;
    }

    private static class SelectionWidget
    extends AbstractWidget {
        private final T value;
        final /* synthetic */ EnumIconWidget this$0;

        SelectionWidget(Vector2i pos, T value) {
            this.this$0 = var1_1;
            super(pos.x(), pos.y(), ((IIcon)value).getRenderSize().x() + 2, ((IIcon)value).getRenderSize().y() + 2, ((IIcon)value).getTooltip());
            this.value = value;
        }

        public void m_5716_(double pMouseX, double pMouseY) {
            super.m_5716_(pMouseX, pMouseY);
            this.this$0.setter.accept(this.value);
        }

        public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }

        public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
            Component tooltip;
            if (this.this$0.getter.get() != this.value) {
                guiGraphics.m_280411_(BUTTON_TEXTURE, this.m_252754_(), this.m_252907_(), ((IIcon)this.value).getRenderSize().x(), ((IIcon)this.value).getRenderSize().y(), this.f_93622_ ? 28.0f : 0.0f, 0.0f, 14, 14, 256, 256);
            } else {
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_ - 2, this.m_252907_() + this.f_93619_ - 2, -16768769);
                guiGraphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.f_93618_ - 3, this.m_252907_() + this.f_93619_ - 3, -10843494);
            }
            IEnderScreen.renderIcon(guiGraphics, new Vector2i(this.m_252754_(), this.m_252907_()), (IIcon)this.value);
            if (this.m_5953_(pMouseX, pMouseY) && (tooltip = ((IIcon)this.value).getTooltip()) != null && !Component.m_237119_().equals((Object)tooltip)) {
                this.this$0.selection.renderTooltipAfterEverything(guiGraphics, List.of(tooltip), pMouseX, pMouseY);
            }
        }
    }

    private class SelectionScreen
    extends Screen
    implements IEnderScreen {
        private final List<IEnderScreen.LateTooltipData> tooltips;

        protected SelectionScreen() {
            super((Component)Component.m_237119_());
            this.tooltips = new ArrayList<IEnderScreen.LateTooltipData>();
        }

        protected void m_7856_() {
            this.m_7787_((GuiEventListener)EnumIconWidget.this);
            EnumIconWidget.this.icons.values().forEach(x$0 -> {
                SelectionWidget cfr_ignored_0 = (SelectionWidget)this.m_142416_((GuiEventListener)x$0);
            });
        }

        public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
            RenderSystem.disableDepthTest();
            this.tooltips.clear();
            this.renderSimpleArea(guiGraphics, EnumIconWidget.this.expandTopLeft, EnumIconWidget.this.expandBottomRight);
            super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
            for (IEnderScreen.LateTooltipData tooltip : this.tooltips) {
                guiGraphics.m_280677_(this.f_96547_, tooltip.getText(), Optional.empty(), tooltip.getMouseX(), tooltip.getMouseY());
            }
            RenderSystem.enableDepthTest();
        }

        public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
            for (GuiEventListener widget : this.m_6702_()) {
                AbstractWidget abstractWidget;
                if (!(widget instanceof AbstractWidget) || !(abstractWidget = (AbstractWidget)widget).m_142518_() || !(widget instanceof IFullScreenListener)) continue;
                IFullScreenListener fullScreenListener = (IFullScreenListener)widget;
                fullScreenListener.onGlobalClick(pMouseX, pMouseY);
            }
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }

        public boolean m_7043_() {
            return false;
        }

        @Override
        public void addTooltip(IEnderScreen.LateTooltipData data) {
            this.tooltips.add(data);
        }

        public void m_7379_() {
            EnumIconWidget.this.m_93692_(false);
            EnumIconWidget.this.isExpanded = false;
            super.m_7379_();
        }

        public void m_6574_(Minecraft minecraft, int width, int height) {
            minecraft.popGuiLayer();
        }
    }
}

