/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.fluid;

import com.enderio.EnderIO;
import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.conduits.common.conduit.type.fluid.FluidConduitType;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FluidConduitData
implements ConduitData<FluidConduitData> {
    public boolean isMultiFluid;
    @Nullable
    private Fluid lockedFluid = null;
    private boolean shouldReset = false;
    private static final String SHOULD_RESET = "ShouldReset";

    public FluidConduitData(boolean isMultiFluid) {
        this.isMultiFluid = isMultiFluid;
    }

    @Nullable
    public Fluid lockedFluid() {
        return this.lockedFluid;
    }

    public void setLockedFluid(@Nullable Fluid lockedFluid) {
        this.lockedFluid = lockedFluid;
    }

    public boolean shouldReset() {
        return this.shouldReset;
    }

    public void setShouldReset(boolean shouldReset) {
        this.shouldReset = shouldReset;
    }

    @Override
    public void onCreated(ConduitType<?> type, Level level, BlockPos pos, @Nullable Player player) {
        if (type instanceof FluidConduitType) {
            FluidConduitType fluidType = (FluidConduitType)type;
            this.isMultiFluid = fluidType.isMultiFluid();
            if (this.isMultiFluid) {
                this.setShouldReset(true);
            }
        }
    }

    @Override
    public void onConnectTo(FluidConduitData otherData) {
        if (this.lockedFluid != null) {
            if (otherData.lockedFluid != null && this.lockedFluid != otherData.lockedFluid) {
                EnderIO.LOGGER.warn("incompatible fluid conduits merged");
            }
            otherData.setLockedFluid(this.lockedFluid);
        } else if (otherData.lockedFluid != null) {
            this.setLockedFluid(otherData.lockedFluid);
        }
    }

    @Override
    public boolean canConnectTo(FluidConduitData otherData) {
        return this.lockedFluid == null || otherData.lockedFluid == null || this.lockedFluid == otherData.lockedFluid;
    }

    public int hashCode() {
        return Objects.hash(this.isMultiFluid, this.shouldReset, this.lockedFluid);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (!this.isMultiFluid) {
            if (this.lockedFluid != null) {
                nbt.m_128359_("Fluid", ForgeRegistries.FLUIDS.getKey((Object)this.lockedFluid).toString());
            } else {
                nbt.m_128359_("Fluid", "null");
            }
        }
        return nbt;
    }

    @Override
    public CompoundTag serializeGuiNBT() {
        CompoundTag nbt = this.serializeNBT();
        nbt.m_128379_(SHOULD_RESET, this.shouldReset);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("Fluid") && !this.isMultiFluid) {
            String fluid = nbt.m_128461_("Fluid");
            if (fluid.equals("null") || ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid)) == Fluids.f_76191_) {
                this.setLockedFluid(null);
            } else {
                this.setLockedFluid((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid)));
            }
        } else {
            this.setLockedFluid(null);
        }
        if (nbt.m_128441_(SHOULD_RESET)) {
            this.shouldReset = nbt.m_128471_(SHOULD_RESET);
        }
    }
}

