/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class MultipleCookingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final CookingBookCategory bookCategory;
    private final ItemStack result;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final RecipeSerializer<? extends AbstractCookingRecipe> serializer;

    private MultipleCookingRecipeBuilder(RecipeCategory pCategory, CookingBookCategory pBookCategory, ItemStack result, Ingredient ingredient, float experience, int cookingTime, RecipeSerializer<? extends AbstractCookingRecipe> serializer) {
        this.category = pCategory;
        this.bookCategory = pBookCategory;
        this.result = result;
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.serializer = serializer;
    }

    public static MultipleCookingRecipeBuilder generic(Ingredient pIngredient, RecipeCategory pCategory, ItemStack pResult, float pExperience, int pCookingTime, RecipeSerializer<? extends AbstractCookingRecipe> pSerializer) {
        return new MultipleCookingRecipeBuilder(pCategory, MultipleCookingRecipeBuilder.determineRecipeCategory(pSerializer, pResult), pResult, pIngredient, pExperience, pCookingTime, pSerializer);
    }

    public static MultipleCookingRecipeBuilder campfireCooking(Ingredient pIngredient, RecipeCategory pCategory, ItemStack pResult, float pExperience, int pCookingTime) {
        return new MultipleCookingRecipeBuilder(pCategory, CookingBookCategory.FOOD, pResult, pIngredient, pExperience, pCookingTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44094_);
    }

    public static MultipleCookingRecipeBuilder blasting(Ingredient pIngredient, RecipeCategory pCategory, ItemStack pResult, float pExperience, int pCookingTime) {
        return new MultipleCookingRecipeBuilder(pCategory, MultipleCookingRecipeBuilder.determineBlastingRecipeCategory(pResult), pResult, pIngredient, pExperience, pCookingTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44092_);
    }

    public static MultipleCookingRecipeBuilder smelting(Ingredient pIngredient, RecipeCategory pCategory, ItemStack pResult, float pExperience, int pCookingTime) {
        return new MultipleCookingRecipeBuilder(pCategory, MultipleCookingRecipeBuilder.determineSmeltingRecipeCategory(pResult), pResult, pIngredient, pExperience, pCookingTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_);
    }

    public static MultipleCookingRecipeBuilder smoking(Ingredient pIngredient, RecipeCategory pCategory, ItemStack pResult, float pExperience, int pCookingTime) {
        return new MultipleCookingRecipeBuilder(pCategory, CookingBookCategory.FOOD, pResult, pIngredient, pExperience, pCookingTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44093_);
    }

    public MultipleCookingRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public MultipleCookingRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.group == null ? "" : this.group, this.bookCategory, this.ingredient, this.result, this.experience, this.cookingTime, this.advancement, pRecipeId.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.serializer));
    }

    private static CookingBookCategory determineSmeltingRecipeCategory(ItemStack pResult) {
        if (pResult.m_41720_().m_41472_()) {
            return CookingBookCategory.FOOD;
        }
        return pResult.m_41720_() instanceof BlockItem ? CookingBookCategory.BLOCKS : CookingBookCategory.MISC;
    }

    private static CookingBookCategory determineBlastingRecipeCategory(ItemStack pResult) {
        return pResult.m_41720_() instanceof BlockItem ? CookingBookCategory.BLOCKS : CookingBookCategory.MISC;
    }

    private static CookingBookCategory determineRecipeCategory(RecipeSerializer<? extends AbstractCookingRecipe> pSerializer, ItemStack pResult) {
        if (pSerializer == RecipeSerializer.f_44091_) {
            return MultipleCookingRecipeBuilder.determineSmeltingRecipeCategory(pResult);
        }
        if (pSerializer == RecipeSerializer.f_44092_) {
            return MultipleCookingRecipeBuilder.determineBlastingRecipeCategory(pResult);
        }
        if (pSerializer != RecipeSerializer.f_44093_ && pSerializer != RecipeSerializer.f_44094_) {
            throw new IllegalStateException("Unknown cooking recipe type");
        }
        return CookingBookCategory.FOOD;
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pId));
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final CookingBookCategory category;
        private final Ingredient ingredient;
        private final ItemStack result;
        private final float experience;
        private final int cookingTime;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<? extends AbstractCookingRecipe> serializer;

        public Result(ResourceLocation pId, String pGroup, CookingBookCategory pCategory, Ingredient pIngredient, ItemStack pResult, float pExperience, int pCookingTime, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId, RecipeSerializer<? extends AbstractCookingRecipe> pSerializer) {
            this.id = pId;
            this.group = pGroup;
            this.category = pCategory;
            this.ingredient = pIngredient;
            this.result = pResult;
            this.experience = pExperience;
            this.cookingTime = pCookingTime;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
            this.serializer = pSerializer;
        }

        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.addProperty("category", this.category.m_7912_());
            pJson.add("ingredient", this.ingredient.m_43942_());
            JsonObject resultObj = new JsonObject();
            resultObj.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_()).toString());
            resultObj.addProperty("count", (Number)this.result.m_41613_());
            pJson.add("result", (JsonElement)resultObj);
            pJson.addProperty("experience", (Number)Float.valueOf(this.experience));
            pJson.addProperty("cookingtime", (Number)this.cookingTime);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

