/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.datagen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.knightlib.KnightLib;
import dev.xylonity.knightlib.config.KnightLibConfig;
import dev.xylonity.knightlib.registry.KnightLibItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class KnightLibAddItemModifier
extends LootModifier {
    public static final Supplier<Codec<KnightLibAddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> KnightLibAddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance))).apply((Applicative)inst, KnightLibAddItemModifier::new)));
    private final Item item;
    private final float chance;

    public KnightLibAddItemModifier(LootItemCondition[] conditionsIn, Item item, float chance) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Mob mob;
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        Object object = context.m_78953_(LootContextParams.f_81455_);
        if (object instanceof Mob && (mob = (Mob)object).m_6095_().m_20674_() == MobCategory.MONSTER && (double)context.m_230907_().m_188501_() <= KnightLibConfig.SMALL_ESSENCE_DROP_RATE && KnightLib.isEnabled(KnightLib.Usage.GREEN_ESSENCES)) {
            generatedLoot.add((Object)new ItemStack((ItemLike)KnightLibItems.SMALL_ESSENCE.get()));
        }
        if ((object = context.m_78953_(LootContextParams.f_81455_)) instanceof Mob && (mob = (Mob)object).m_6095_().m_20674_() == MobCategory.MONSTER && (double)context.m_230907_().m_188501_() <= KnightLibConfig.GREAT_ESSENCE_DROP_RATE && KnightLib.isEnabled(KnightLib.Usage.GREEN_ESSENCES)) {
            generatedLoot.add((Object)new ItemStack((ItemLike)KnightLibItems.GREAT_ESSENCE.get()));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

