/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.creativewirelesstransmitter.datageneration;

import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.util.ColorMap;
import com.ultramega.creativewirelesstransmitter.datageneration.BlockModels;
import com.ultramega.creativewirelesstransmitter.registry.ModBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockModelGenerator
extends BlockStateProvider {
    private final BlockModels models = new BlockModels(this);

    public BlockModelGenerator(PackOutput output, String id, ExistingFileHelper existingFileHelper) {
        super(output, id, existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.genCubeAllCutoutModels(ModBlocks.CREATIVE_WIRELESS_TRANSMITTER);
    }

    private <T extends Block> void genCubeAllCutoutModels(ColorMap<T> blockMap) {
        blockMap.forEach((color, registryObject) -> {
            Block block = (Block)registryObject.get();
            String folderName = blockMap.get(ColorMap.DEFAULT_COLOR).getId().m_135815_();
            this.models.simpleBlockStateModel(block, state -> {
                if (Boolean.FALSE.equals(state.m_61143_((Property)NetworkNodeBlock.CONNECTED))) {
                    return this.models.createCubeAllCutoutModel("block/" + folderName + "/disconnected", this.resourceLocation(folderName, folderName), this.resourceLocation(folderName, folderName), this.resourceLocation(folderName, "cutouts/disconnected"));
                }
                BlockModelBuilder model = this.models.createCubeAllCutoutModel("block/" + folderName + "/" + color, this.resourceLocation(folderName, folderName), this.resourceLocation(folderName, folderName), this.resourceLocation(folderName, "cutouts/" + color));
                this.simpleBlockItem(block, (ModelFile)model);
                return model;
            });
        });
    }

    private ResourceLocation resourceLocation(String folderName, String name) {
        return new ResourceLocation("creativewirelesstransmitter", "block/" + folderName + "/" + name);
    }
}

