/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.util.HeightUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;

public class TeleportFromMapPacket
extends BaseC2SMessage {
    private final BlockPos pos;
    private final boolean unknownY;
    private final ResourceKey<Level> dimension;

    public TeleportFromMapPacket(BlockPos pos, boolean unknownY, ResourceKey<Level> dimension) {
        this.pos = pos;
        this.unknownY = unknownY;
        this.dimension = dimension;
    }

    TeleportFromMapPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.unknownY = buf.readBoolean();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_());
    }

    public MessageType getType() {
        return FTBChunksNet.TELEPORT_FROM_MAP;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.unknownY);
        buf.m_130085_(this.dimension.m_135782_());
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer p = (ServerPlayer)context.getPlayer();
        ServerLevel level = p.m_20194_().m_129880_(this.dimension);
        if (level != null && p.m_20310_(2)) {
            int x1 = this.pos.m_123341_();
            int y1 = this.pos.m_123342_();
            int z1 = this.pos.m_123343_();
            if (this.unknownY) {
                LevelChunk chunkAccess = level.m_46745_(this.pos);
                int topY = chunkAccess.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x1, z1);
                if (topY == chunkAccess.m_141937_() - 1) {
                    return;
                }
                BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(x1, topY + 2, z1);
                int water = HeightUtils.getHeight((Level)level, (ChunkAccess)chunkAccess, blockPos);
                if (blockPos.m_123342_() == -32767) {
                    blockPos.m_142448_(70);
                } else if (water != -32767) {
                    blockPos.m_142448_(Math.max(blockPos.m_123342_(), water));
                }
                y1 = blockPos.m_123342_() + 1;
            }
            p.m_8999_(level, (double)x1 + 0.5, (double)y1 + 0.1, (double)z1 + 0.5, p.m_146908_(), p.m_146909_());
        }
    }
}

