/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.compat.twilightforest.items;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.compat.base.Ability;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.items.upgrades._base.ISunIntensityMod;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;

public class TwiLightUpgrade
extends UpgradeItem
implements ISunIntensityMod {
    public static final ResourceKey<DimensionType> TWILIGHT_DIM_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("twilightforest", "twilight_forest_type"));

    public TwiLightUpgrade() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    public static boolean isTwilight(Level level) {
        return level != null && Objects.equals(level.m_220362_(), TWILIGHT_DIM_TYPE);
    }

    @Override
    public float applySunIntensityModifier(ISolarPanelTile tile, float value) {
        if (tile.doesSeeSky() && TwiLightUpgrade.isTwilight(tile.level())) {
            return 0.45f;
        }
        return value;
    }

    @Override
    public boolean canInstall(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        return TwiLightUpgrade.isTwilight(tile.level()) && super.canInstall(tile, stack, upgradeInv);
    }

    @Override
    public boolean canStayInPanel(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        return TwiLightUpgrade.isTwilight(tile.level()) && super.canStayInPanel(tile, stack, upgradeInv);
    }

    @Override
    public <T> Optional<T> findAbility(Ability<T> ability) {
        return ability.findIn(new Object[]{this}).or(() -> super.findAbility(ability));
    }
}

