/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.block;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.blocks.ICustomBlockItem;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.hammerlib.core.adapter.BlockHarvestAdapter;
import org.zeith.solarflux.block.SolarPanelBlockItem;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;
import org.zeith.solarflux.panels.SolarPanel;

public class SolarPanelBlock
extends BaseEntityBlock
implements ICustomBlockItem {
    public final SolarPanel panel;
    public final ResourceLocation registryName;

    public SolarPanelBlock(SolarPanel panel, ResourceLocation registryName) {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60988_().m_60955_().m_60978_(1.5f).m_60999_());
        this.registryName = registryName;
        this.bindTool();
        this.panel = panel;
    }

    protected void bindTool() {
        BlockHarvestAdapter.bindTool((BlockHarvestAdapter.MineableType)BlockHarvestAdapter.MineableType.PICKAXE, (Tier)Tiers.IRON, (Block[])new Block[]{this});
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockAPI.ticker();
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (stack.m_41782_()) {
            SolarPanelTile spt = null;
            BlockEntity tile = level.m_7702_(pos);
            if (tile instanceof SolarPanelTile) {
                spt = (SolarPanelTile)tile;
            } else {
                spt = (SolarPanelTile)this.m_142194_(pos, state);
                level.m_151523_((BlockEntity)spt);
            }
            spt.loadFromItem(stack);
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        NonNullList stacks = NonNullList.m_122779_();
        BlockEntity tileentity = (BlockEntity)builder.m_287261_(LootContextParams.f_81462_);
        if (tileentity instanceof SolarPanelTile) {
            SolarPanelTile te = (SolarPanelTile)tileentity;
            stacks.add((Object)te.generateItem(this.panel));
        } else {
            stacks.add((Object)new ItemStack((ItemLike)this.panel));
        }
        return stacks;
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SolarPanelTile) {
            SolarPanelTile spt = (SolarPanelTile)blockEntity;
            return spt.getShape(this);
        }
        return Shapes.m_166049_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)this.panel.getPanelData().height, (double)1.0);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof SolarPanelTile) {
            SolarPanelTile spt = (SolarPanelTile)blockEntity;
            spt.resetVoxelShape();
        }
    }

    public VoxelShape recalcShape(BlockGetter world, BlockPos pos) {
        SolarPanel.SolarPanelData pd = this.panel.getPanelData();
        float ph = pd.height;
        VoxelShape baseShape = Shapes.m_166049_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)ph, (double)1.0);
        Stream.Builder<VoxelShape> shapes = Stream.builder();
        boolean west = false;
        boolean east = false;
        boolean north = false;
        boolean south = false;
        float h = ph;
        float h2 = h + 0.015625f;
        west = world.m_8055_(pos.m_122024_()).m_60734_() != this;
        if (west) {
            shapes.add(Shapes.m_166049_((double)0.0, (double)h, (double)0.0625, (double)0.0625, (double)h2, (double)0.9375));
        }
        if (east = world.m_8055_(pos.m_122029_()).m_60734_() != this) {
            shapes.add(Shapes.m_166049_((double)0.9375, (double)h, (double)0.0625, (double)1.0, (double)h2, (double)0.9375));
        }
        if (north = world.m_8055_(pos.m_122012_()).m_60734_() != this) {
            shapes.add(Shapes.m_166049_((double)0.0625, (double)h, (double)0.0, (double)0.9375, (double)h2, (double)0.0625));
        }
        if (south = world.m_8055_(pos.m_122019_()).m_60734_() != this) {
            shapes.add(Shapes.m_166049_((double)0.0625, (double)h, (double)0.9375, (double)0.9375, (double)h2, (double)1.0));
        }
        if (west || north || world.m_8055_(pos.m_122024_().m_122012_()).m_60734_() != this) {
            shapes.add(Shapes.m_166049_((double)0.0, (double)h, (double)0.0, (double)0.0625, (double)h2, (double)0.0625));
        }
        if (east || north || world.m_8055_(pos.m_122029_().m_122012_()).m_60734_() != this) {
            shapes.add(Shapes.m_166049_((double)0.9375, (double)h, (double)0.0, (double)1.0, (double)h2, (double)0.0625));
        }
        if (south || east || world.m_8055_(pos.m_122019_().m_122029_()).m_60734_() != this) {
            shapes.add(Shapes.m_166049_((double)0.9375, (double)h, (double)0.9375, (double)1.0, (double)h2, (double)1.0));
        }
        if (west || south || world.m_8055_(pos.m_122024_().m_122019_()).m_60734_() != this) {
            shapes.add(Shapes.m_166049_((double)0.0, (double)h, (double)0.9375, (double)0.0625, (double)h2, (double)1.0));
        }
        return Shapes.m_83124_((VoxelShape)baseShape, (VoxelShape[])((VoxelShape[])shapes.build().toArray(VoxelShape[]::new)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (player instanceof ServerPlayer && (blockEntity = worldIn.m_7702_(pos)) instanceof SolarPanelTile) {
            UpgradeItem iu;
            int amt;
            Item item;
            SolarPanelTile tbs = (SolarPanelTile)blockEntity;
            ItemStack held = player.m_21120_(handIn);
            if (!held.m_41619_() && (item = held.m_41720_()) instanceof UpgradeItem && (amt = tbs.getUpgrades(iu = (UpgradeItem)item)) < iu.getMaxUpgradesInstalled(tbs) && iu.canInstall(tbs, held, tbs.upgradeInventory)) {
                int installed = 0;
                for (int i = 0; i < tbs.upgradeInventory.getSlots(); ++i) {
                    ItemStack stack = tbs.upgradeInventory.getStackInSlot(i);
                    if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)held)) {
                        int allow = Math.min(iu.getMaxUpgradesInstalled(tbs) - tbs.getUpgrades(iu), Math.min(iu.getMaxStackSize(stack) - stack.m_41613_(), held.m_41613_()));
                        stack.m_41769_(allow);
                        held.m_41774_(allow);
                        installed += allow;
                        break;
                    }
                    if (!stack.m_41619_()) continue;
                    int allow = Math.min(iu.getMaxUpgradesInstalled(tbs) - tbs.getUpgrades(iu), held.m_41613_());
                    ItemStack copy = held.m_41777_();
                    held.m_41774_(allow);
                    copy.m_41764_(allow);
                    tbs.upgradeInventory.setStackInSlot(i, copy);
                    installed += allow;
                    break;
                }
                if (installed > 0) {
                    tbs.m_6596_();
                    iu.onInstalled(tbs, amt, tbs.getUpgrades(iu));
                    worldIn.m_5594_(null, pos, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.1f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
            ContainerAPI.openContainerTile((Player)player, (BlockEntity)tbs);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7278_(BlockState p_60457_) {
        return true;
    }

    public int m_6782_(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof SolarPanelTile) {
            SolarPanelTile sp = (SolarPanelTile)blockEntity;
            long cap = sp.capacity.getValueL();
            return cap > 0L ? (int)Math.round(15.0 * (double)sp.energy / (double)cap) : 0;
        }
        return 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        SolarPanelTile tile = new SolarPanelTile(pos, state);
        tile.setDelegate(this.panel);
        return tile;
    }

    public boolean m_7420_(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return false;
    }

    public BlockItem createBlockItem() {
        return new SolarPanelBlockItem(this, new Item.Properties());
    }
}

