/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.trades;

import com.google.common.collect.ImmutableMap;
import com.lion.graveyard.init.TGItems;
import com.lion.graveyard.init.TGTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class NamelessHangedTradeOffers {
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> NAMELESS_HANGED_TRADES = NamelessHangedTradeOffers.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory(Items.f_42584_, 4, 1, 12, 1), new SellItemFactory(Items.f_42401_, 1, 1, 12, 1), new SellItemFactory(Items.f_42518_, 2, 1, 12, 1), new SellItemFactory(Items.f_41996_, 8, 1, 6, 1), new SellItemFactory(Items.f_41955_, 2, 1, 12, 1), new SellItemFactory(Items.f_41954_, 2, 1, 12, 1), new SellItemFactory(Items.f_41842_, 12, 32, 6, 1), new SellItemFactory(Items.f_42792_, 16, 1, 1, 1), new SellItemFactory(Items.f_220216_, 8, 32, 6, 1), new SellItemFactory(Items.f_42049_, 8, 16, 6, 1), new SellItemFactory(Items.f_42050_, 8, 16, 6, 1), new SellItemFactory(Items.f_42691_, 1, 1, 24, 1), new SellItemFactory(Items.f_42675_, 10, 1, 1, 1), new SellItemFactory(TGItems.DARK_IRON_INGOT.get(), 4, 1, 6, 1), new SellItemFactory(TGItems.SOUL_FIRE_BRAZIER.get(), 6, 1, 4, 1), new SellItemFactory(TGItems.FIRE_BRAZIER.get(), 6, 1, 4, 1), new SellItemFactory(TGItems.PEDESTAL.get(), 6, 1, 4, 1), new SellItemFactory(TGItems.CANDLE_HOLDER.get(), 6, 1, 4, 1), new SellItemFactory(TGItems.OSSUARY.get(), 6, 1, 1, 1), new SellItemFactory(Items.f_151016_, 10, 32, 6, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new SellMapFactory(4, TGTags.ON_RUINS_EXPLORER_MAPS, "filled_map.ruins", MapDecoration.Type.TARGET_X, 1, 5)}));

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> copyToFastUtilMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    public static class SellItemFactory
    implements VillagerTrades.ItemListing {
        private final ItemStack sell;
        private final int price;
        private final int count;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public SellItemFactory(Block block, int price, int count, int maxUses, int experience) {
            this(new ItemStack((ItemLike)block), price, count, maxUses, experience);
        }

        public SellItemFactory(Item item, int price, int count, int experience) {
            this(new ItemStack((ItemLike)item), price, count, 12, experience);
        }

        public SellItemFactory(Item item, int price, int count, int maxUses, int experience) {
            this(new ItemStack((ItemLike)item), price, count, maxUses, experience);
        }

        public SellItemFactory(ItemStack stack, int price, int count, int maxUses, int experience) {
            this(stack, price, count, maxUses, experience, 0.05f);
        }

        public SellItemFactory(ItemStack stack, int price, int count, int maxUses, int experience, float multiplier) {
            this.sell = stack;
            this.price = price;
            this.count = count;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemStack((ItemLike)TGItems.CORRUPTION.get(), this.price), new ItemStack((ItemLike)this.sell.m_41720_(), this.count), this.maxUses, this.experience, this.multiplier);
        }
    }

    public static class SellMapFactory
    implements VillagerTrades.ItemListing {
        private final int price;
        private final TagKey<Structure> structure;
        private final String nameKey;
        private final MapDecoration.Type iconType;
        private final int maxUses;
        private final int experience;

        public SellMapFactory(int price, TagKey<Structure> structure, String nameKey, MapDecoration.Type iconType, int maxUses, int experience) {
            this.price = price;
            this.structure = structure;
            this.nameKey = nameKey;
            this.iconType = iconType;
            this.maxUses = maxUses;
            this.experience = experience;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            if (!(entity.m_20193_() instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverWorld = (ServerLevel)entity.m_20193_();
            BlockPos blockPos = serverWorld.m_215011_(this.structure, entity.m_20183_(), 100, true);
            if (blockPos != null) {
                ItemStack itemStack = MapItem.m_42886_((Level)serverWorld, (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverWorld, (ItemStack)itemStack);
                MapItemSavedData.m_77925_((ItemStack)itemStack, (BlockPos)blockPos, (String)"+", (MapDecoration.Type)this.iconType);
                itemStack.m_41714_((Component)Component.m_237115_((String)this.nameKey));
                return new MerchantOffer(new ItemStack((ItemLike)TGItems.CORRUPTION.get(), this.price), new ItemStack((ItemLike)Items.f_42522_), itemStack, this.maxUses, this.experience, 0.2f);
            }
            return null;
        }
    }

    public static class SellEnchantedToolFactory
    implements VillagerTrades.ItemListing {
        private final ItemStack tool;
        private final int basePrice;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public SellEnchantedToolFactory(Item item, int basePrice, int maxUses, int experience) {
            this(item, basePrice, maxUses, experience, 0.05f);
        }

        public SellEnchantedToolFactory(Item item, int basePrice, int maxUses, int experience, float multiplier) {
            this.tool = new ItemStack((ItemLike)item);
            this.basePrice = basePrice;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            int i = 5 + random.m_188503_(15);
            ItemStack itemStack = EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)new ItemStack((ItemLike)this.tool.m_41720_()), (int)i, (boolean)false);
            int j = Math.min(this.basePrice, 64);
            ItemStack itemStack2 = new ItemStack((ItemLike)TGItems.CORRUPTION.get(), j);
            return new MerchantOffer(itemStack2, itemStack, this.maxUses, this.experience, this.multiplier);
        }
    }
}

