/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.gui;

import com.lion.graveyard.blockentities.GravestoneBlockEntity;
import com.lion.graveyard.blockentities.renders.GravestoneBlockEntityRenderer;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class GravestoneScreen
extends Screen {
    private final GravestoneBlockEntity sign;
    private int ticksSinceOpened;
    private int currentRow;
    private TextFieldHelper selectionManager;
    private WoodType signType;
    private SignRenderer.SignModel model;
    private String[] text;
    private SignText signText;

    public GravestoneScreen(GravestoneBlockEntity blockEntity, boolean filtered) {
        this(blockEntity, filtered, (Component)Component.m_237115_((String)"gravestone.edit"));
    }

    public GravestoneScreen(GravestoneBlockEntity blockEntity, boolean filtered, Component title) {
        super(title);
        this.sign = blockEntity;
        this.signText = blockEntity.getText();
        this.signType = SignBlock.m_247329_((Block)blockEntity.m_58900_().m_60734_());
        this.text = (String[])IntStream.range(0, 4).mapToObj(line -> this.signText.m_277138_(line, filtered)).map(Component::getString).toArray(String[]::new);
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.finishEditing()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 144, 200, 20).m_253136_());
        this.selectionManager = new TextFieldHelper(() -> this.text[this.currentRow], this::setCurrentRowMessage, TextFieldHelper.m_95153_((Minecraft)this.f_96541_), TextFieldHelper.m_95182_((Minecraft)this.f_96541_), string -> this.f_96541_.f_91062_.m_92895_(string) <= this.sign.getMaxTextWidth());
        this.signType = WoodType.f_61830_;
        this.model = GravestoneBlockEntityRenderer.createSignModel(this.f_96541_.m_167973_(), this.signType);
    }

    private void setCurrentRowMessage(String message) {
        this.text[this.currentRow] = message;
        this.signText = this.signText.m_276913_(this.currentRow, (Component)Component.m_237113_((String)message));
        this.sign.setText(this.signText);
    }

    public void m_7861_() {
        ClientPacketListener clientPlayNetworkHandler = this.f_96541_.m_91403_();
        if (clientPlayNetworkHandler != null) {
            clientPlayNetworkHandler.m_104955_((Packet)new ServerboundSignUpdatePacket(this.sign.m_58899_(), true, this.text[0], this.text[1], this.text[2], this.text[3]));
        }
    }

    public void m_86600_() {
        ++this.ticksSinceOpened;
        if (!this.sign.m_58903_().m_155262_(this.sign.m_58900_())) {
            this.finishEditing();
        }
    }

    private void finishEditing() {
        this.sign.m_6596_();
        this.f_96541_.m_91152_(null);
    }

    public boolean m_5534_(char chr, int modifiers) {
        this.selectionManager.m_95143_(chr);
        return true;
    }

    public void m_7379_() {
        this.finishEditing();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.currentRow = this.currentRow - 1 & 3;
            this.selectionManager.m_95193_();
            return true;
        }
        if (keyCode != 264 && keyCode != 257 && keyCode != 335) {
            return this.selectionManager.m_95145_(keyCode) || super.m_7933_(keyCode, scanCode, modifiers);
        }
        this.currentRow = this.currentRow + 1 & 3;
        this.selectionManager.m_95193_();
        return true;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int p;
        int o;
        String string;
        int n;
        PoseStack matrices = context.m_280168_();
        Lighting.m_84930_();
        this.m_280273_(context);
        context.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        matrices.m_85836_();
        matrices.m_85837_((double)(this.f_96543_ / 2), 0.0, 50.0);
        matrices.m_85841_(93.75f, -93.75f, 93.75f);
        matrices.m_85837_(0.0, -1.3125, 0.0);
        BlockState blockState = this.sign.m_58900_();
        boolean bl = blockState.m_60734_() instanceof StandingSignBlock;
        if (!bl) {
            matrices.m_85837_(0.0, -0.3125, 0.0);
        }
        matrices.m_85836_();
        matrices.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        MultiBufferSource.BufferSource immediate = this.f_96541_.m_91269_().m_110104_();
        SignRenderer.SignModel var10002 = this.model;
        Objects.requireNonNull(var10002);
        VertexConsumer vertexConsumer2 = GravestoneBlockEntityRenderer.getConsumer((MultiBufferSource)immediate, this.sign.m_58900_().m_60734_());
        this.model.f_112507_.f_104207_ = false;
        this.model.f_173655_.m_104301_(matrices, vertexConsumer2, 0xF000F0, OverlayTexture.f_118083_);
        matrices.m_85849_();
        matrices.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
        matrices.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
        int i = this.signText.m_276773_().m_41071_();
        int j = this.selectionManager.m_95194_();
        int k = this.selectionManager.m_95197_();
        int l = this.text.length * 5;
        Matrix4f matrix4f = matrices.m_85850_().m_252922_();
        int m = this.currentRow * 10 - l;
        for (n = 0; n < this.text.length; ++n) {
            string = this.text[n];
            if (string == null) continue;
            if (this.f_96547_.m_92718_()) {
                string = this.f_96547_.m_92801_(string);
            }
            float f = -this.f_96541_.f_91062_.m_92895_(string) / 2;
            this.f_96541_.f_91062_.m_272078_(string, f, (float)(n * 10 - l), i, false, matrix4f, (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0, false);
            if (n != this.currentRow || j < 0 || !bl) continue;
            o = this.f_96541_.f_91062_.m_92895_(string.substring(0, Math.min(j, string.length())));
            p = o - this.f_96541_.f_91062_.m_92895_(string) / 2;
            if (j < string.length()) continue;
            this.f_96541_.f_91062_.m_272078_("_", (float)p, (float)m, i, false, matrix4f, (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0, false);
        }
        immediate.m_109911_();
        for (n = 0; n < this.text.length; ++n) {
            string = this.text[n];
            if (string == null || n != this.currentRow || j < 0) continue;
            int q = this.f_96541_.f_91062_.m_92895_(string.substring(0, Math.min(j, string.length())));
            o = q - this.f_96541_.f_91062_.m_92895_(string) / 2;
            if (bl && j < string.length()) {
                context.m_280509_(o, m - 1, o + 1, m + 10, 0xFF000000 | i);
            }
            if (k == j) continue;
            p = Math.min(j, k);
            int r = Math.max(j, k);
            int s = this.f_96541_.f_91062_.m_92895_(string.substring(0, p)) - this.f_96541_.f_91062_.m_92895_(string) / 2;
            int t = this.f_96541_.f_91062_.m_92895_(string.substring(0, r)) - this.f_96541_.f_91062_.m_92895_(string) / 2;
            int u = Math.min(s, t);
            int v = Math.max(s, t);
            RenderSystem.enableColorLogicOp();
            RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
            context.m_280509_(u, m, v, m + 10, -16776961);
            RenderSystem.disableColorLogicOp();
        }
        matrices.m_85849_();
        Lighting.m_84931_();
        super.m_88315_(context, mouseX, mouseY, delta);
    }
}

