/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.TubeWormBlock;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class TubeWormFeature
extends Feature<NoneFeatureConfiguration> {
    public TubeWormFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos.MutableBlockPos ventBottom = new BlockPos.MutableBlockPos();
        ventBottom.m_122190_((Vec3i)context.m_159777_());
        while (!level.m_8055_((BlockPos)ventBottom).m_60819_().m_76178_() && ventBottom.m_123342_() > level.m_141937_()) {
            ventBottom.m_122184_(0, -1, 0);
        }
        if (ventBottom.m_123342_() < level.m_5736_() - 30 && level.m_8055_(ventBottom.m_7495_()).equals(Blocks.f_152496_.m_49966_())) {
            for (int i = 0; i < 4 + randomsource.m_188503_(4); ++i) {
                BlockPos wormAttachedToPos;
                BlockPos wormAt = ventBottom.m_7949_().m_7918_(randomsource.m_188503_(10) - 5, randomsource.m_188503_(4), randomsource.m_188503_(10) - 5);
                Direction wormAttachDirection = Direction.DOWN;
                Direction randomDirection = Direction.m_122407_((int)(2 + randomsource.m_188503_(3)));
                BlockPos randomPos = wormAt.m_121945_(randomDirection);
                BlockState randomState = level.m_8055_(randomPos);
                if (randomState.m_60783_((BlockGetter)level, randomPos, randomDirection.m_122424_())) {
                    wormAttachDirection = randomDirection;
                    wormAttachedToPos = randomPos;
                } else {
                    while (level.m_8055_(wormAt).m_60783_((BlockGetter)level, wormAt.m_7494_(), Direction.DOWN) && wormAt.m_123342_() < level.m_151558_()) {
                        wormAt = wormAt.m_7494_();
                    }
                    while (!level.m_8055_(wormAt).m_60819_().m_76178_() && wormAt.m_123342_() > level.m_141937_()) {
                        wormAt = wormAt.m_7495_();
                    }
                    wormAttachedToPos = wormAt.m_7495_();
                }
                if (level.m_8055_(wormAt).m_204336_(ACTagRegistry.TUBE_WORM_AVOIDS) || level.m_8055_(wormAt).m_60713_((Block)ACBlockRegistry.TUBE_WORM.get())) continue;
                int maxSegments = 4 + randomsource.m_188503_(12);
                this.growWorm(level, wormAttachedToPos, wormAttachDirection, randomsource, maxSegments);
            }
            return true;
        }
        return false;
    }

    private void growWorm(WorldGenLevel level, BlockPos wormAttachedToPos, Direction wormAttachDirection, RandomSource randomsource, int maxSegments) {
        if (wormAttachedToPos.m_123342_() > level.m_5736_() - 30) {
            return;
        }
        BlockPos.MutableBlockPos prevWorm = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos worm = new BlockPos.MutableBlockPos();
        prevWorm.m_122190_((Vec3i)wormAttachedToPos);
        worm.m_122190_((Vec3i)wormAttachedToPos.m_121945_(wormAttachDirection.m_122424_()));
        BlockState defaultWormState = (BlockState)((Block)ACBlockRegistry.TUBE_WORM.get()).m_49966_().m_61124_((Property)TubeWormBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        boolean canBranch = false;
        for (int placedWorms = 0; placedWorms < maxSegments; ++placedWorms) {
            BlockState wormState = defaultWormState;
            prevWorm.m_122190_((Vec3i)worm);
            if (worm.m_123342_() > level.m_5736_() - 30) {
                return;
            }
            if (canBranch) {
                if (randomsource.m_188499_()) {
                    Direction randomDirection = Direction.m_122407_((int)(2 + randomsource.m_188503_(3)));
                    worm.m_122184_(randomDirection.m_122429_(), randomDirection.m_122430_(), randomDirection.m_122431_());
                    if (!level.m_6425_((BlockPos)worm).m_76178_()) {
                        if (!level.m_8055_((BlockPos)worm).m_60713_(Blocks.f_49990_) || !level.m_8055_((BlockPos)worm).m_247087_()) {
                            return;
                        }
                        if (level.m_8055_((BlockPos)prevWorm).m_247087_() || level.m_8055_((BlockPos)prevWorm).m_60713_((Block)ACBlockRegistry.TUBE_WORM.get())) {
                            level.m_7731_((BlockPos)prevWorm, (BlockState)((BlockState)wormState.m_61124_(TubeWormBlock.TUBE_TYPE, (Comparable)((Object)TubeWormBlock.TubeShape.TURN))).m_61124_((Property)TubeWormBlock.FACING, (Comparable)randomDirection), 3);
                        }
                        wormState = (BlockState)((BlockState)wormState.m_61124_(TubeWormBlock.TUBE_TYPE, (Comparable)((Object)TubeWormBlock.TubeShape.ELBOW))).m_61124_((Property)TubeWormBlock.FACING, (Comparable)randomDirection.m_122424_());
                    } else {
                        worm.m_122190_((Vec3i)prevWorm);
                        worm.m_122184_(0, 1, 0);
                    }
                }
                canBranch = false;
            } else {
                worm.m_122184_(0, 1, 0);
                boolean bl = canBranch = placedWorms > 1;
            }
            if (level.m_6425_((BlockPos)worm).m_76178_()) break;
            if (!level.m_8055_((BlockPos)worm).m_247087_()) continue;
            level.m_7731_((BlockPos)worm, wormState, 3);
        }
        BlockPos fixAttachementPos = wormAttachedToPos.m_121945_(wormAttachDirection.m_122424_());
        if (wormAttachDirection.m_122434_().m_122479_() && (level.m_8055_(fixAttachementPos).m_247087_() || level.m_8055_(fixAttachementPos).m_60713_((Block)ACBlockRegistry.TUBE_WORM.get()))) {
            level.m_7731_(fixAttachementPos, (BlockState)((BlockState)defaultWormState.m_61124_(TubeWormBlock.TUBE_TYPE, (Comparable)((Object)TubeWormBlock.TubeShape.ELBOW))).m_61124_((Property)TubeWormBlock.FACING, (Comparable)wormAttachDirection), 3);
        }
    }
}

