/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.GeothermalVentBlock;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class AcidVentFeature
extends Feature<NoneFeatureConfiguration> {
    public AcidVentFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos ventBottom;
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        if (level.m_8055_((ventBottom = context.m_159777_()).m_7495_()).equals(Blocks.f_220864_.m_49966_())) {
            AcidVentFeature.drawVent(level, ventBottom, randomsource);
            for (int i = 0; i < 1 + randomsource.m_188503_(2); ++i) {
                AcidVentFeature.drawVent(level, ventBottom.m_7918_(randomsource.m_188503_(8) - 4, 0, randomsource.m_188503_(8) - 4), randomsource);
            }
        }
        return false;
    }

    private static void drawVent(WorldGenLevel level, BlockPos ventBottom, RandomSource randomsource) {
        int height = randomsource.m_188503_(4) + 2;
        int acidCount = 0;
        while (!(level.m_6425_(ventBottom).m_76178_() && level.m_8055_(ventBottom).m_60795_() || ventBottom.m_123342_() >= level.m_151558_() - height)) {
            ventBottom = ventBottom.m_7494_();
            if (++acidCount < 3) continue;
            return;
        }
        if (!AcidVentFeature.hasClearance(level, ventBottom, height)) {
            return;
        }
        ventBottom = ventBottom.m_7495_();
        AcidVentFeature.drawOrb(level, ventBottom, randomsource, 1 + randomsource.m_188503_(1), 2 + randomsource.m_188503_(3), 1 + randomsource.m_188503_(1));
        level.m_7731_(ventBottom.m_122012_(), Blocks.f_152496_.m_49966_(), 2);
        level.m_7731_(ventBottom.m_122019_(), Blocks.f_152496_.m_49966_(), 2);
        level.m_7731_(ventBottom.m_122029_(), Blocks.f_152496_.m_49966_(), 2);
        level.m_7731_(ventBottom.m_122024_(), Blocks.f_152496_.m_49966_(), 2);
        level.m_7731_(ventBottom.m_7495_(), Blocks.f_152496_.m_49966_(), 2);
        level.m_7731_(ventBottom, ((LiquidBlock)ACBlockRegistry.ACID.get()).m_49966_(), 2);
        int middleStart = Math.max(1, height / 3);
        int middleTop = middleStart * 2;
        for (int i = 1; i <= height; ++i) {
            BlockState vent = i <= middleStart ? (BlockState)((BlockState)((Block)ACBlockRegistry.GEOTHERMAL_VENT.get()).m_49966_().m_61124_((Property)GeothermalVentBlock.SMOKE_TYPE, (Comparable)Integer.valueOf(3))).m_61124_((Property)GeothermalVentBlock.SPAWNING_PARTICLES, (Comparable)Boolean.valueOf(i == height)) : (i > middleTop ? (BlockState)((BlockState)((Block)ACBlockRegistry.GEOTHERMAL_VENT_THIN.get()).m_49966_().m_61124_((Property)GeothermalVentBlock.SMOKE_TYPE, (Comparable)Integer.valueOf(3))).m_61124_((Property)GeothermalVentBlock.SPAWNING_PARTICLES, (Comparable)Boolean.valueOf(i == height)) : (BlockState)((BlockState)((Block)ACBlockRegistry.GEOTHERMAL_VENT_MEDIUM.get()).m_49966_().m_61124_((Property)GeothermalVentBlock.SMOKE_TYPE, (Comparable)Integer.valueOf(3))).m_61124_((Property)GeothermalVentBlock.SPAWNING_PARTICLES, (Comparable)Boolean.valueOf(i == height)));
            level.m_7731_(ventBottom.m_6630_(i), vent, 2);
        }
        level.m_7731_(ventBottom.m_6630_(height + 1), Blocks.f_50627_.m_49966_(), 2);
    }

    private static boolean hasClearance(WorldGenLevel level, BlockPos ventBottom, int height) {
        for (int i = 0; i < height; ++i) {
            if (level.m_46859_(ventBottom.m_6630_(1 + i))) continue;
            return false;
        }
        return true;
    }

    private static void drawOrb(WorldGenLevel level, BlockPos center, RandomSource random, int radiusX, int radiusY, int radiusZ) {
        double equalRadius = (double)(radiusX + radiusY + radiusZ) / 3.0;
        for (int x = -radiusX; x <= radiusX; ++x) {
            for (int y = -radiusY; y <= radiusY; ++y) {
                for (int z = -radiusZ; z <= radiusZ; ++z) {
                    BlockPos fill = center.m_7918_(x, y, z);
                    if (!(fill.m_203202_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_()) <= equalRadius * equalRadius + (double)(random.m_188501_() * 2.0f)) || !AcidVentFeature.canReplace(level.m_8055_(fill)) || fill.m_123342_() > center.m_123342_()) continue;
                    level.m_7731_(fill, Blocks.f_152496_.m_49966_(), 2);
                }
            }
        }
    }

    private static boolean canReplace(BlockState state) {
        return !state.m_204336_(ACTagRegistry.UNMOVEABLE) && !state.m_60795_();
    }
}

